/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class DeleteChatsRoomMessageRequest {
    private String roomJid;
    private String messageId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoomJid() {
        return this.roomJid;
    }

    public void setRoomJid(String roomJid) {
        this.roomJid = roomJid;
    }

    public DeleteChatsRoomMessageRequest withRoomJid(String roomJid) {
        this.setRoomJid(roomJid);
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public DeleteChatsRoomMessageRequest withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteChatsRoomMessageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.roomJid == null) {
            throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for DeleteChatsRoomMessageRequest.");
        }
        if (this.messageId == null) {
            throw new IllegalStateException("Missing the required parameter 'messageId' when building request for DeleteChatsRoomMessageRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/chats/rooms/{roomJid}/messages/{messageId}").withPathParameter("roomJid", this.roomJid).withPathParameter("messageId", this.messageId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roomJid, String messageId) {
        return new Builder().withRequiredParams(roomJid, messageId);
    }

    public static class Builder {
        private final DeleteChatsRoomMessageRequest request = new DeleteChatsRoomMessageRequest();

        private Builder() {
        }

        public Builder withRoomJid(String roomJid) {
            this.request.setRoomJid(roomJid);
            return this;
        }

        public Builder withMessageId(String messageId) {
            this.request.setMessageId(messageId);
            return this;
        }

        public Builder withRequiredParams(String roomJid, String messageId) {
            this.request.setRoomJid(roomJid);
            this.request.setMessageId(messageId);
            return this;
        }

        public DeleteChatsRoomMessageRequest build() {
            if (this.request.roomJid == null) {
                throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for DeleteChatsRoomMessageRequest.");
            }
            if (this.request.messageId == null) {
                throw new IllegalStateException("Missing the required parameter 'messageId' when building request for DeleteChatsRoomMessageRequest.");
            }
            return this.request;
        }
    }
}

