/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetTelephonyAgentGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetTelephonyAgentsGreetingsMeRequest;
import com.mypurecloud.sdk.v2.api.request.GetTelephonyMediaregionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetTelephonySipmessagesConversationHeadersRequest;
import com.mypurecloud.sdk.v2.api.request.GetTelephonySipmessagesConversationRequest;
import com.mypurecloud.sdk.v2.api.request.GetTelephonySiptracesDownloadDownloadIdRequest;
import com.mypurecloud.sdk.v2.api.request.GetTelephonySiptracesRequest;
import com.mypurecloud.sdk.v2.api.request.PostTelephonySiptracesDownloadRequest;
import com.mypurecloud.sdk.v2.api.request.PutTelephonyAgentGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.PutTelephonyAgentsGreetingsMeRequest;
import com.mypurecloud.sdk.v2.model.AgentGreeting;
import com.mypurecloud.sdk.v2.model.Callheader;
import com.mypurecloud.sdk.v2.model.Callmessage;
import com.mypurecloud.sdk.v2.model.MediaRegions;
import com.mypurecloud.sdk.v2.model.SIPSearchPublicRequest;
import com.mypurecloud.sdk.v2.model.SelfAgentGreeting;
import com.mypurecloud.sdk.v2.model.SignedUrlResponse;
import com.mypurecloud.sdk.v2.model.SipDownloadResponse;
import com.mypurecloud.sdk.v2.model.SipSearchResult;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class TelephonyApi {
    private final ApiClient pcapiClient;

    public TelephonyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TelephonyApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public AgentGreeting getTelephonyAgentGreetings(String agentId) throws IOException, ApiException {
        return this.getTelephonyAgentGreetings(this.createGetTelephonyAgentGreetingsRequest(agentId));
    }

    public ApiResponse<AgentGreeting> getTelephonyAgentGreetingsWithHttpInfo(String agentId) throws IOException {
        return this.getTelephonyAgentGreetings(this.createGetTelephonyAgentGreetingsRequest(agentId).withHttpInfo());
    }

    private GetTelephonyAgentGreetingsRequest createGetTelephonyAgentGreetingsRequest(String agentId) {
        return GetTelephonyAgentGreetingsRequest.builder().withAgentId(agentId).build();
    }

    public AgentGreeting getTelephonyAgentGreetings(GetTelephonyAgentGreetingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AgentGreeting> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AgentGreeting>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AgentGreeting> getTelephonyAgentGreetings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AgentGreeting>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public SelfAgentGreeting getTelephonyAgentsGreetingsMe() throws IOException, ApiException {
        return this.getTelephonyAgentsGreetingsMe(this.createGetTelephonyAgentsGreetingsMeRequest());
    }

    public ApiResponse<SelfAgentGreeting> getTelephonyAgentsGreetingsMeWithHttpInfo() throws IOException {
        return this.getTelephonyAgentsGreetingsMe(this.createGetTelephonyAgentsGreetingsMeRequest().withHttpInfo());
    }

    private GetTelephonyAgentsGreetingsMeRequest createGetTelephonyAgentsGreetingsMeRequest() {
        return GetTelephonyAgentsGreetingsMeRequest.builder().build();
    }

    public SelfAgentGreeting getTelephonyAgentsGreetingsMe(GetTelephonyAgentsGreetingsMeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SelfAgentGreeting> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SelfAgentGreeting>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SelfAgentGreeting> getTelephonyAgentsGreetingsMe(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SelfAgentGreeting>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public MediaRegions getTelephonyMediaregions() throws IOException, ApiException {
        return this.getTelephonyMediaregions(this.createGetTelephonyMediaregionsRequest());
    }

    public ApiResponse<MediaRegions> getTelephonyMediaregionsWithHttpInfo() throws IOException {
        return this.getTelephonyMediaregions(this.createGetTelephonyMediaregionsRequest().withHttpInfo());
    }

    private GetTelephonyMediaregionsRequest createGetTelephonyMediaregionsRequest() {
        return GetTelephonyMediaregionsRequest.builder().build();
    }

    public MediaRegions getTelephonyMediaregions(GetTelephonyMediaregionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<MediaRegions> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<MediaRegions>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<MediaRegions> getTelephonyMediaregions(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<MediaRegions>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Callmessage getTelephonySipmessagesConversation(String conversationId) throws IOException, ApiException {
        return this.getTelephonySipmessagesConversation(this.createGetTelephonySipmessagesConversationRequest(conversationId));
    }

    public ApiResponse<Callmessage> getTelephonySipmessagesConversationWithHttpInfo(String conversationId) throws IOException {
        return this.getTelephonySipmessagesConversation(this.createGetTelephonySipmessagesConversationRequest(conversationId).withHttpInfo());
    }

    private GetTelephonySipmessagesConversationRequest createGetTelephonySipmessagesConversationRequest(String conversationId) {
        return GetTelephonySipmessagesConversationRequest.builder().withConversationId(conversationId).build();
    }

    public Callmessage getTelephonySipmessagesConversation(GetTelephonySipmessagesConversationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Callmessage> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Callmessage>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Callmessage> getTelephonySipmessagesConversation(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Callmessage>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Callheader getTelephonySipmessagesConversationHeaders(String conversationId, List<String> keys) throws IOException, ApiException {
        return this.getTelephonySipmessagesConversationHeaders(this.createGetTelephonySipmessagesConversationHeadersRequest(conversationId, keys));
    }

    public ApiResponse<Callheader> getTelephonySipmessagesConversationHeadersWithHttpInfo(String conversationId, List<String> keys) throws IOException {
        return this.getTelephonySipmessagesConversationHeaders(this.createGetTelephonySipmessagesConversationHeadersRequest(conversationId, keys).withHttpInfo());
    }

    private GetTelephonySipmessagesConversationHeadersRequest createGetTelephonySipmessagesConversationHeadersRequest(String conversationId, List<String> keys) {
        return GetTelephonySipmessagesConversationHeadersRequest.builder().withConversationId(conversationId).withKeys(keys).build();
    }

    public Callheader getTelephonySipmessagesConversationHeaders(GetTelephonySipmessagesConversationHeadersRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Callheader> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Callheader>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Callheader> getTelephonySipmessagesConversationHeaders(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Callheader>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public SipSearchResult getTelephonySiptraces(Date dateStart, Date dateEnd, String callId, String toUser, String fromUser, String conversationId) throws IOException, ApiException {
        return this.getTelephonySiptraces(this.createGetTelephonySiptracesRequest(dateStart, dateEnd, callId, toUser, fromUser, conversationId));
    }

    public ApiResponse<SipSearchResult> getTelephonySiptracesWithHttpInfo(Date dateStart, Date dateEnd, String callId, String toUser, String fromUser, String conversationId) throws IOException {
        return this.getTelephonySiptraces(this.createGetTelephonySiptracesRequest(dateStart, dateEnd, callId, toUser, fromUser, conversationId).withHttpInfo());
    }

    private GetTelephonySiptracesRequest createGetTelephonySiptracesRequest(Date dateStart, Date dateEnd, String callId, String toUser, String fromUser, String conversationId) {
        return GetTelephonySiptracesRequest.builder().withDateStart(dateStart).withDateEnd(dateEnd).withCallId(callId).withToUser(toUser).withFromUser(fromUser).withConversationId(conversationId).build();
    }

    public SipSearchResult getTelephonySiptraces(GetTelephonySiptracesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SipSearchResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SipSearchResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SipSearchResult> getTelephonySiptraces(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SipSearchResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public SignedUrlResponse getTelephonySiptracesDownloadDownloadId(String downloadId) throws IOException, ApiException {
        return this.getTelephonySiptracesDownloadDownloadId(this.createGetTelephonySiptracesDownloadDownloadIdRequest(downloadId));
    }

    public ApiResponse<SignedUrlResponse> getTelephonySiptracesDownloadDownloadIdWithHttpInfo(String downloadId) throws IOException {
        return this.getTelephonySiptracesDownloadDownloadId(this.createGetTelephonySiptracesDownloadDownloadIdRequest(downloadId).withHttpInfo());
    }

    private GetTelephonySiptracesDownloadDownloadIdRequest createGetTelephonySiptracesDownloadDownloadIdRequest(String downloadId) {
        return GetTelephonySiptracesDownloadDownloadIdRequest.builder().withDownloadId(downloadId).build();
    }

    public SignedUrlResponse getTelephonySiptracesDownloadDownloadId(GetTelephonySiptracesDownloadDownloadIdRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SignedUrlResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SignedUrlResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SignedUrlResponse> getTelephonySiptracesDownloadDownloadId(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SignedUrlResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public SipDownloadResponse postTelephonySiptracesDownload(SIPSearchPublicRequest sIPSearchPublicRequest) throws IOException, ApiException {
        return this.postTelephonySiptracesDownload(this.createPostTelephonySiptracesDownloadRequest(sIPSearchPublicRequest));
    }

    public ApiResponse<SipDownloadResponse> postTelephonySiptracesDownloadWithHttpInfo(SIPSearchPublicRequest sIPSearchPublicRequest) throws IOException {
        return this.postTelephonySiptracesDownload(this.createPostTelephonySiptracesDownloadRequest(sIPSearchPublicRequest).withHttpInfo());
    }

    private PostTelephonySiptracesDownloadRequest createPostTelephonySiptracesDownloadRequest(SIPSearchPublicRequest sIPSearchPublicRequest) {
        return PostTelephonySiptracesDownloadRequest.builder().withSIPSearchPublicRequest(sIPSearchPublicRequest).build();
    }

    public SipDownloadResponse postTelephonySiptracesDownload(PostTelephonySiptracesDownloadRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SipDownloadResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SipDownloadResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SipDownloadResponse> postTelephonySiptracesDownload(ApiRequest<SIPSearchPublicRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SipDownloadResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AgentGreeting putTelephonyAgentGreetings(String agentId, AgentGreeting body) throws IOException, ApiException {
        return this.putTelephonyAgentGreetings(this.createPutTelephonyAgentGreetingsRequest(agentId, body));
    }

    public ApiResponse<AgentGreeting> putTelephonyAgentGreetingsWithHttpInfo(String agentId, AgentGreeting body) throws IOException {
        return this.putTelephonyAgentGreetings(this.createPutTelephonyAgentGreetingsRequest(agentId, body).withHttpInfo());
    }

    private PutTelephonyAgentGreetingsRequest createPutTelephonyAgentGreetingsRequest(String agentId, AgentGreeting body) {
        return PutTelephonyAgentGreetingsRequest.builder().withAgentId(agentId).withBody(body).build();
    }

    public AgentGreeting putTelephonyAgentGreetings(PutTelephonyAgentGreetingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AgentGreeting> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AgentGreeting>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AgentGreeting> putTelephonyAgentGreetings(ApiRequest<AgentGreeting> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AgentGreeting>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public SelfAgentGreeting putTelephonyAgentsGreetingsMe(SelfAgentGreeting body) throws IOException, ApiException {
        return this.putTelephonyAgentsGreetingsMe(this.createPutTelephonyAgentsGreetingsMeRequest(body));
    }

    public ApiResponse<SelfAgentGreeting> putTelephonyAgentsGreetingsMeWithHttpInfo(SelfAgentGreeting body) throws IOException {
        return this.putTelephonyAgentsGreetingsMe(this.createPutTelephonyAgentsGreetingsMeRequest(body).withHttpInfo());
    }

    private PutTelephonyAgentsGreetingsMeRequest createPutTelephonyAgentsGreetingsMeRequest(SelfAgentGreeting body) {
        return PutTelephonyAgentsGreetingsMeRequest.builder().withBody(body).build();
    }

    public SelfAgentGreeting putTelephonyAgentsGreetingsMe(PutTelephonyAgentsGreetingsMeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SelfAgentGreeting> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SelfAgentGreeting>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SelfAgentGreeting> putTelephonyAgentsGreetingsMe(ApiRequest<SelfAgentGreeting> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SelfAgentGreeting>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

