/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetUsageEventsDefinitionRequest;
import com.mypurecloud.sdk.v2.api.request.GetUsageEventsDefinitionsRequest;
import com.mypurecloud.sdk.v2.api.request.PostUsageEventsAggregatesQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostUsageEventsQueryRequest;
import com.mypurecloud.sdk.v2.model.EventAggregatesQueryRequest;
import com.mypurecloud.sdk.v2.model.EventAggregatesResponse;
import com.mypurecloud.sdk.v2.model.EventDefinition;
import com.mypurecloud.sdk.v2.model.EventDefinitionListing;
import com.mypurecloud.sdk.v2.model.EventQueryRequest;
import com.mypurecloud.sdk.v2.model.EventQueryResponse;
import java.io.IOException;

public class OperationalEventsApi {
    private final ApiClient pcapiClient;

    public OperationalEventsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OperationalEventsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public EventDefinition getUsageEventsDefinition(String eventDefinitionId) throws IOException, ApiException {
        return this.getUsageEventsDefinition(this.createGetUsageEventsDefinitionRequest(eventDefinitionId));
    }

    public ApiResponse<EventDefinition> getUsageEventsDefinitionWithHttpInfo(String eventDefinitionId) throws IOException {
        return this.getUsageEventsDefinition(this.createGetUsageEventsDefinitionRequest(eventDefinitionId).withHttpInfo());
    }

    private GetUsageEventsDefinitionRequest createGetUsageEventsDefinitionRequest(String eventDefinitionId) {
        return GetUsageEventsDefinitionRequest.builder().withEventDefinitionId(eventDefinitionId).build();
    }

    public EventDefinition getUsageEventsDefinition(GetUsageEventsDefinitionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<EventDefinition> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<EventDefinition>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<EventDefinition> getUsageEventsDefinition(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<EventDefinition>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public EventDefinitionListing getUsageEventsDefinitions() throws IOException, ApiException {
        return this.getUsageEventsDefinitions(this.createGetUsageEventsDefinitionsRequest());
    }

    public ApiResponse<EventDefinitionListing> getUsageEventsDefinitionsWithHttpInfo() throws IOException {
        return this.getUsageEventsDefinitions(this.createGetUsageEventsDefinitionsRequest().withHttpInfo());
    }

    private GetUsageEventsDefinitionsRequest createGetUsageEventsDefinitionsRequest() {
        return GetUsageEventsDefinitionsRequest.builder().build();
    }

    public EventDefinitionListing getUsageEventsDefinitions(GetUsageEventsDefinitionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<EventDefinitionListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<EventDefinitionListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<EventDefinitionListing> getUsageEventsDefinitions(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<EventDefinitionListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public EventAggregatesResponse postUsageEventsAggregatesQuery(EventAggregatesQueryRequest body) throws IOException, ApiException {
        return this.postUsageEventsAggregatesQuery(this.createPostUsageEventsAggregatesQueryRequest(body));
    }

    public ApiResponse<EventAggregatesResponse> postUsageEventsAggregatesQueryWithHttpInfo(EventAggregatesQueryRequest body) throws IOException {
        return this.postUsageEventsAggregatesQuery(this.createPostUsageEventsAggregatesQueryRequest(body).withHttpInfo());
    }

    private PostUsageEventsAggregatesQueryRequest createPostUsageEventsAggregatesQueryRequest(EventAggregatesQueryRequest body) {
        return PostUsageEventsAggregatesQueryRequest.builder().withBody(body).build();
    }

    public EventAggregatesResponse postUsageEventsAggregatesQuery(PostUsageEventsAggregatesQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<EventAggregatesResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<EventAggregatesResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<EventAggregatesResponse> postUsageEventsAggregatesQuery(ApiRequest<EventAggregatesQueryRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<EventAggregatesResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public EventQueryResponse postUsageEventsQuery(String before, String after, String pageSize, EventQueryRequest body) throws IOException, ApiException {
        return this.postUsageEventsQuery(this.createPostUsageEventsQueryRequest(before, after, pageSize, body));
    }

    public ApiResponse<EventQueryResponse> postUsageEventsQueryWithHttpInfo(String before, String after, String pageSize, EventQueryRequest body) throws IOException {
        return this.postUsageEventsQuery(this.createPostUsageEventsQueryRequest(before, after, pageSize, body).withHttpInfo());
    }

    private PostUsageEventsQueryRequest createPostUsageEventsQueryRequest(String before, String after, String pageSize, EventQueryRequest body) {
        return PostUsageEventsQueryRequest.builder().withBefore(before).withAfter(after).withPageSize(pageSize).withBody(body).build();
    }

    public EventQueryResponse postUsageEventsQuery(PostUsageEventsQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<EventQueryResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<EventQueryResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<EventQueryResponse> postUsageEventsQuery(ApiRequest<EventQueryRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<EventQueryResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

