/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.WorkitemFilter;
import com.mypurecloud.sdk.v2.model.WorkitemQuerySort;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WorkitemQueryPostRequest
implements Serializable {
    private Integer pageSize = null;
    private SelectEnum select = null;
    private List<WorkitemFilter> filters = null;
    private List<String> attributes = null;
    private String after = null;
    private WorkitemQuerySort sort = null;
    private List<ExpandsEnum> expands = null;

    public WorkitemQueryPostRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.filters = new ArrayList<WorkitemFilter>();
            this.attributes = new ArrayList<String>();
            this.expands = new ArrayList<ExpandsEnum>();
        }
    }

    public WorkitemQueryPostRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public WorkitemQueryPostRequest select(SelectEnum select) {
        this.select = select;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify the value 'Count' for this parameter in order to return only the record count.")
    @JsonProperty(value="select")
    public SelectEnum getSelect() {
        return this.select;
    }

    public void setSelect(SelectEnum select) {
        this.select = select;
    }

    public WorkitemQueryPostRequest filters(List<WorkitemFilter> filters) {
        this.filters = filters;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of filter objects to be used in the search. Valid filter names are: 'id', 'name', 'description', 'languageId', 'priority', 'dateCreated', 'dateModified', 'dateDue', 'dateExpires', 'durationInSeconds', 'ttl', 'statusId', 'statusCategory', 'dateClosed', 'externalContactId', 'reporterId', 'queueId', 'externalTag', 'modifiedBy', 'assignmentState', 'divisionId', 'customFields.<custom field name>'")
    @JsonProperty(value="filters")
    public List<WorkitemFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<WorkitemFilter> filters) {
        this.filters = filters;
    }

    public WorkitemQueryPostRequest attributes(List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="List of entity attributes to be retrieved in the result.")
    @JsonProperty(value="attributes")
    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public WorkitemQueryPostRequest after(String after) {
        this.after = after;
        return this;
    }

    @ApiModelProperty(example="null", value="The cursor that points to the end of the set of entities that has been returned.")
    @JsonProperty(value="after")
    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public WorkitemQueryPostRequest sort(WorkitemQuerySort sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(example="null", value="Sort")
    @JsonProperty(value="sort")
    public WorkitemQuerySort getSort() {
        return this.sort;
    }

    public void setSort(WorkitemQuerySort sort) {
        this.sort = sort;
    }

    public WorkitemQueryPostRequest expands(List<ExpandsEnum> expands) {
        this.expands = expands;
        return this;
    }

    @ApiModelProperty(example="null", value="List of entity attributes to be expanded in the result.")
    @JsonProperty(value="expands")
    public List<ExpandsEnum> getExpands() {
        return this.expands;
    }

    public void setExpands(List<ExpandsEnum> expands) {
        this.expands = expands;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemQueryPostRequest workitemQueryPostRequest = (WorkitemQueryPostRequest)o;
        return Objects.equals(this.pageSize, workitemQueryPostRequest.pageSize) && Objects.equals((Object)this.select, (Object)workitemQueryPostRequest.select) && Objects.equals(this.filters, workitemQueryPostRequest.filters) && Objects.equals(this.attributes, workitemQueryPostRequest.attributes) && Objects.equals(this.after, workitemQueryPostRequest.after) && Objects.equals(this.sort, workitemQueryPostRequest.sort) && Objects.equals(this.expands, workitemQueryPostRequest.expands);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageSize, this.select, this.filters, this.attributes, this.after, this.sort, this.expands});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemQueryPostRequest {\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    select: ").append(this.toIndentedString((Object)this.select)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    after: ").append(this.toIndentedString(this.after)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    expands: ").append(this.toIndentedString(this.expands)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SelectEnumDeserializer.class)
    public static enum SelectEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COUNT("Count");

        private String value;

        private SelectEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SelectEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SelectEnum value : SelectEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SelectEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ExpandsEnumDeserializer.class)
    public static enum ExpandsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TYPE("type"),
        WORKBIN("workbin"),
        STATUS("status"),
        ASSIGNEE("assignee"),
        REPORTER("reporter"),
        QUEUE("queue");

        private String value;

        private ExpandsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExpandsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ExpandsEnum value : ExpandsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ExpandsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ExpandsEnumDeserializer
    extends StdDeserializer<ExpandsEnum> {
        public ExpandsEnumDeserializer() {
            super(ExpandsEnumDeserializer.class);
        }

        public ExpandsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ExpandsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SelectEnumDeserializer
    extends StdDeserializer<SelectEnum> {
        public SelectEnumDeserializer() {
            super(SelectEnumDeserializer.class);
        }

        public SelectEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SelectEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

