/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ActionEventActionMap;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.Browser;
import com.mypurecloud.sdk.v2.model.Device;
import com.mypurecloud.sdk.v2.model.EventAction;
import com.mypurecloud.sdk.v2.model.JourneyCampaign;
import com.mypurecloud.sdk.v2.model.JourneyGeolocation;
import com.mypurecloud.sdk.v2.model.Referrer;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class WebActionEvent
implements Serializable {
    private EventAction action = null;
    private ActionEventActionMap actionMap = null;
    private AddressableEntityRef actionTarget = null;
    private Long timeToDisposition = null;
    private String errorCode = null;
    private String errorMessage = null;
    private String userAgentString = null;
    private Browser browser = null;
    private Device device = null;
    private JourneyGeolocation geolocation = null;
    private String ipAddress = null;
    private String ipOrganization = null;
    private JourneyCampaign mktCampaign = null;
    private Referrer visitReferrer = null;

    public WebActionEvent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public WebActionEvent action(EventAction action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The action that triggered the event.")
    @JsonProperty(value="action")
    public EventAction getAction() {
        return this.action;
    }

    public void setAction(EventAction action) {
        this.action = action;
    }

    public WebActionEvent actionMap(ActionEventActionMap actionMap) {
        this.actionMap = actionMap;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The action map that triggered the action.")
    @JsonProperty(value="actionMap")
    public ActionEventActionMap getActionMap() {
        return this.actionMap;
    }

    public void setActionMap(ActionEventActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public WebActionEvent actionTarget(AddressableEntityRef actionTarget) {
        this.actionTarget = actionTarget;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The target for engagement actions.")
    @JsonProperty(value="actionTarget")
    public AddressableEntityRef getActionTarget() {
        return this.actionTarget;
    }

    public void setActionTarget(AddressableEntityRef actionTarget) {
        this.actionTarget = actionTarget;
    }

    public WebActionEvent timeToDisposition(Long timeToDisposition) {
        this.timeToDisposition = timeToDisposition;
        return this;
    }

    @ApiModelProperty(example="null", value="Milliseconds elapsed until the action is disposed.")
    @JsonProperty(value="timeToDisposition")
    public Long getTimeToDisposition() {
        return this.timeToDisposition;
    }

    public void setTimeToDisposition(Long timeToDisposition) {
        this.timeToDisposition = timeToDisposition;
    }

    public WebActionEvent errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(example="null", value="Code of the error returned when the action fails.")
    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public WebActionEvent errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="Message of the error returned when the action fails.")
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public WebActionEvent userAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="HTTP User-Agent string (see https://tools.ietf.org/html/rfc1945#section-10.15).")
    @JsonProperty(value="userAgentString")
    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void setUserAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
    }

    public WebActionEvent browser(Browser browser) {
        this.browser = browser;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Customer's browser.")
    @JsonProperty(value="browser")
    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public WebActionEvent device(Device device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Customer's device.")
    @JsonProperty(value="device")
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public WebActionEvent geolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's geolocation.")
    @JsonProperty(value="geolocation")
    public JourneyGeolocation getGeolocation() {
        return this.geolocation;
    }

    public void setGeolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
    }

    public WebActionEvent ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Visitor's IP address.")
    @JsonProperty(value="ipAddress")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public WebActionEvent ipOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="Visitor's IP-based organization or ISP name.")
    @JsonProperty(value="ipOrganization")
    public String getIpOrganization() {
        return this.ipOrganization;
    }

    public void setIpOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
    }

    public WebActionEvent mktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
        return this;
    }

    @ApiModelProperty(example="null", value="Marketing / traffic source information.")
    @JsonProperty(value="mktCampaign")
    public JourneyCampaign getMktCampaign() {
        return this.mktCampaign;
    }

    public void setMktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
    }

    public WebActionEvent visitReferrer(Referrer visitReferrer) {
        this.visitReferrer = visitReferrer;
        return this;
    }

    @ApiModelProperty(example="null", value="Visit's referrer.")
    @JsonProperty(value="visitReferrer")
    public Referrer getVisitReferrer() {
        return this.visitReferrer;
    }

    public void setVisitReferrer(Referrer visitReferrer) {
        this.visitReferrer = visitReferrer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebActionEvent webActionEvent = (WebActionEvent)o;
        return Objects.equals(this.action, webActionEvent.action) && Objects.equals(this.actionMap, webActionEvent.actionMap) && Objects.equals(this.actionTarget, webActionEvent.actionTarget) && Objects.equals(this.timeToDisposition, webActionEvent.timeToDisposition) && Objects.equals(this.errorCode, webActionEvent.errorCode) && Objects.equals(this.errorMessage, webActionEvent.errorMessage) && Objects.equals(this.userAgentString, webActionEvent.userAgentString) && Objects.equals(this.browser, webActionEvent.browser) && Objects.equals(this.device, webActionEvent.device) && Objects.equals(this.geolocation, webActionEvent.geolocation) && Objects.equals(this.ipAddress, webActionEvent.ipAddress) && Objects.equals(this.ipOrganization, webActionEvent.ipOrganization) && Objects.equals(this.mktCampaign, webActionEvent.mktCampaign) && Objects.equals(this.visitReferrer, webActionEvent.visitReferrer);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.actionMap, this.actionTarget, this.timeToDisposition, this.errorCode, this.errorMessage, this.userAgentString, this.browser, this.device, this.geolocation, this.ipAddress, this.ipOrganization, this.mktCampaign, this.visitReferrer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebActionEvent {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    actionMap: ").append(this.toIndentedString(this.actionMap)).append("\n");
        sb.append("    actionTarget: ").append(this.toIndentedString(this.actionTarget)).append("\n");
        sb.append("    timeToDisposition: ").append(this.toIndentedString(this.timeToDisposition)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    userAgentString: ").append(this.toIndentedString(this.userAgentString)).append("\n");
        sb.append("    browser: ").append(this.toIndentedString(this.browser)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    geolocation: ").append(this.toIndentedString(this.geolocation)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    ipOrganization: ").append(this.toIndentedString(this.ipOrganization)).append("\n");
        sb.append("    mktCampaign: ").append(this.toIndentedString(this.mktCampaign)).append("\n");
        sb.append("    visitReferrer: ").append(this.toIndentedString(this.visitReferrer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

