/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TwitterDataIngestionRuleRequest
implements Serializable {
    private String name = null;
    private String description = null;
    private String searchTerms = null;
    private List<String> countries = null;

    public TwitterDataIngestionRuleRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.countries = new ArrayList<String>();
        }
    }

    public TwitterDataIngestionRuleRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the data ingestion rule.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TwitterDataIngestionRuleRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the data ingestion rule.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TwitterDataIngestionRuleRequest searchTerms(String searchTerms) {
        this.searchTerms = searchTerms;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Search terms for X (formally Twitter).")
    @JsonProperty(value="searchTerms")
    public String getSearchTerms() {
        return this.searchTerms;
    }

    public void setSearchTerms(String searchTerms) {
        this.searchTerms = searchTerms;
    }

    public TwitterDataIngestionRuleRequest countries(List<String> countries) {
        this.countries = countries;
        return this;
    }

    @ApiModelProperty(example="null", value="ISO 3166-1 alpha-2 country codes. Ingestion of matching tweets will be restricted to tweets posted in the countries specified here. Defaults to worldwide.")
    @JsonProperty(value="countries")
    public List<String> getCountries() {
        return this.countries;
    }

    public void setCountries(List<String> countries) {
        this.countries = countries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterDataIngestionRuleRequest twitterDataIngestionRuleRequest = (TwitterDataIngestionRuleRequest)o;
        return Objects.equals(this.name, twitterDataIngestionRuleRequest.name) && Objects.equals(this.description, twitterDataIngestionRuleRequest.description) && Objects.equals(this.searchTerms, twitterDataIngestionRuleRequest.searchTerms) && Objects.equals(this.countries, twitterDataIngestionRuleRequest.countries);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.searchTerms, this.countries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TwitterDataIngestionRuleRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    searchTerms: ").append(this.toIndentedString(this.searchTerms)).append("\n");
        sb.append("    countries: ").append(this.toIndentedString(this.countries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

