/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConnectedEdge;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SiteConnection
implements Serializable {
    private String id = null;
    private String name = null;
    private String selfUri = null;
    private Boolean managed = null;
    private TypeEnum type = null;
    private Boolean enabled = null;
    private MediaModelEnum mediaModel = null;
    private List<ConnectedEdge> edgeList = null;
    private Boolean coreSite = null;
    private List<DomainEntityRef> primaryCoreSites = null;
    private List<DomainEntityRef> secondaryCoreSites = null;

    public SiteConnection() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.edgeList = new ArrayList<ConnectedEdge>();
            this.primaryCoreSites = new ArrayList<DomainEntityRef>();
            this.secondaryCoreSites = new ArrayList<DomainEntityRef>();
        }
    }

    public SiteConnection id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SiteConnection name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SiteConnection selfUri(String selfUri) {
        this.selfUri = selfUri;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public void setSelfUri(String selfUri) {
        this.selfUri = selfUri;
    }

    public SiteConnection managed(Boolean managed) {
        this.managed = managed;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="managed")
    public Boolean getManaged() {
        return this.managed;
    }

    public void setManaged(Boolean managed) {
        this.managed = managed;
    }

    public SiteConnection type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Connection method from site to site (Direct, Indirect, CloudProxy")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SiteConnection enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if the current site is linked")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @ApiModelProperty(example="null", value="Media model for the current site.")
    @JsonProperty(value="mediaModel")
    public MediaModelEnum getMediaModel() {
        return this.mediaModel;
    }

    @ApiModelProperty(example="null", value="All of the edges to which the site connects")
    @JsonProperty(value="edgeList")
    public List<ConnectedEdge> getEdgeList() {
        return this.edgeList;
    }

    @ApiModelProperty(example="null", value="The core site")
    @JsonProperty(value="coreSite")
    public Boolean getCoreSite() {
        return this.coreSite;
    }

    @ApiModelProperty(example="null", value="List of site ids names and selfUris for the primary core sites")
    @JsonProperty(value="primaryCoreSites")
    public List<DomainEntityRef> getPrimaryCoreSites() {
        return this.primaryCoreSites;
    }

    @ApiModelProperty(example="null", value="List of site ids names and selfUris for the secondary core sites")
    @JsonProperty(value="secondaryCoreSites")
    public List<DomainEntityRef> getSecondaryCoreSites() {
        return this.secondaryCoreSites;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SiteConnection siteConnection = (SiteConnection)o;
        return Objects.equals(this.id, siteConnection.id) && Objects.equals(this.name, siteConnection.name) && Objects.equals(this.selfUri, siteConnection.selfUri) && Objects.equals(this.managed, siteConnection.managed) && Objects.equals((Object)this.type, (Object)siteConnection.type) && Objects.equals(this.enabled, siteConnection.enabled) && Objects.equals((Object)this.mediaModel, (Object)siteConnection.mediaModel) && Objects.equals(this.edgeList, siteConnection.edgeList) && Objects.equals(this.coreSite, siteConnection.coreSite) && Objects.equals(this.primaryCoreSites, siteConnection.primaryCoreSites) && Objects.equals(this.secondaryCoreSites, siteConnection.secondaryCoreSites);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.selfUri, this.managed, this.type, this.enabled, this.mediaModel, this.edgeList, this.coreSite, this.primaryCoreSites, this.secondaryCoreSites});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SiteConnection {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    managed: ").append(this.toIndentedString(this.managed)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    mediaModel: ").append(this.toIndentedString((Object)this.mediaModel)).append("\n");
        sb.append("    edgeList: ").append(this.toIndentedString(this.edgeList)).append("\n");
        sb.append("    coreSite: ").append(this.toIndentedString(this.coreSite)).append("\n");
        sb.append("    primaryCoreSites: ").append(this.toIndentedString(this.primaryCoreSites)).append("\n");
        sb.append("    secondaryCoreSites: ").append(this.toIndentedString(this.secondaryCoreSites)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DIRECT("Direct"),
        INDIRECT("Indirect"),
        CLOUDPROXY("CloudProxy");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaModelEnumDeserializer.class)
    public static enum MediaModelEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PREMISES("Premises"),
        CLOUD("Cloud");

        private String value;

        private MediaModelEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaModelEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaModelEnum value : MediaModelEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaModelEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaModelEnumDeserializer
    extends StdDeserializer<MediaModelEnum> {
        public MediaModelEnumDeserializer() {
            super(MediaModelEnumDeserializer.class);
        }

        public MediaModelEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaModelEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

