/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.MessageSubtypeSettings;
import com.mypurecloud.sdk.v2.model.ServiceLevel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class MessageMediaSettings
implements Serializable {
    private Boolean enableAutoAnswer = null;
    private Integer alertingTimeoutSeconds = null;
    private ServiceLevel serviceLevel = null;
    private Double autoAnswerAlertToneSeconds = null;
    private Double manualAnswerAlertToneSeconds = null;
    private Map<String, MessageSubtypeSettings> subTypeSettings = null;

    public MessageMediaSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public MessageMediaSettings enableAutoAnswer(Boolean enableAutoAnswer) {
        this.enableAutoAnswer = enableAutoAnswer;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if auto-answer is enabled for the given media type or subtype (default is false).  Subtype settings take precedence over media type settings.")
    @JsonProperty(value="enableAutoAnswer")
    public Boolean getEnableAutoAnswer() {
        return this.enableAutoAnswer;
    }

    public void setEnableAutoAnswer(Boolean enableAutoAnswer) {
        this.enableAutoAnswer = enableAutoAnswer;
    }

    public MessageMediaSettings alertingTimeoutSeconds(Integer alertingTimeoutSeconds) {
        this.alertingTimeoutSeconds = alertingTimeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The alerting timeout for the media type, in seconds")
    @JsonProperty(value="alertingTimeoutSeconds")
    public Integer getAlertingTimeoutSeconds() {
        return this.alertingTimeoutSeconds;
    }

    public void setAlertingTimeoutSeconds(Integer alertingTimeoutSeconds) {
        this.alertingTimeoutSeconds = alertingTimeoutSeconds;
    }

    public MessageMediaSettings serviceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    @ApiModelProperty(example="null", value="The targeted service level for the media type")
    @JsonProperty(value="serviceLevel")
    public ServiceLevel getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public MessageMediaSettings autoAnswerAlertToneSeconds(Double autoAnswerAlertToneSeconds) {
        this.autoAnswerAlertToneSeconds = autoAnswerAlertToneSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="How long to play the alerting tone for an auto-answer interaction")
    @JsonProperty(value="autoAnswerAlertToneSeconds")
    public Double getAutoAnswerAlertToneSeconds() {
        return this.autoAnswerAlertToneSeconds;
    }

    public void setAutoAnswerAlertToneSeconds(Double autoAnswerAlertToneSeconds) {
        this.autoAnswerAlertToneSeconds = autoAnswerAlertToneSeconds;
    }

    public MessageMediaSettings manualAnswerAlertToneSeconds(Double manualAnswerAlertToneSeconds) {
        this.manualAnswerAlertToneSeconds = manualAnswerAlertToneSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="How long to play the alerting tone for a manual-answer interaction")
    @JsonProperty(value="manualAnswerAlertToneSeconds")
    public Double getManualAnswerAlertToneSeconds() {
        return this.manualAnswerAlertToneSeconds;
    }

    public void setManualAnswerAlertToneSeconds(Double manualAnswerAlertToneSeconds) {
        this.manualAnswerAlertToneSeconds = manualAnswerAlertToneSeconds;
    }

    public MessageMediaSettings subTypeSettings(Map<String, MessageSubtypeSettings> subTypeSettings) {
        this.subTypeSettings = subTypeSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Map of media subtype to media subtype specific settings.")
    @JsonProperty(value="subTypeSettings")
    public Map<String, MessageSubtypeSettings> getSubTypeSettings() {
        return this.subTypeSettings;
    }

    public void setSubTypeSettings(Map<String, MessageSubtypeSettings> subTypeSettings) {
        this.subTypeSettings = subTypeSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageMediaSettings messageMediaSettings = (MessageMediaSettings)o;
        return Objects.equals(this.enableAutoAnswer, messageMediaSettings.enableAutoAnswer) && Objects.equals(this.alertingTimeoutSeconds, messageMediaSettings.alertingTimeoutSeconds) && Objects.equals(this.serviceLevel, messageMediaSettings.serviceLevel) && Objects.equals(this.autoAnswerAlertToneSeconds, messageMediaSettings.autoAnswerAlertToneSeconds) && Objects.equals(this.manualAnswerAlertToneSeconds, messageMediaSettings.manualAnswerAlertToneSeconds) && Objects.equals(this.subTypeSettings, messageMediaSettings.subTypeSettings);
    }

    public int hashCode() {
        return Objects.hash(this.enableAutoAnswer, this.alertingTimeoutSeconds, this.serviceLevel, this.autoAnswerAlertToneSeconds, this.manualAnswerAlertToneSeconds, this.subTypeSettings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageMediaSettings {\n");
        sb.append("    enableAutoAnswer: ").append(this.toIndentedString(this.enableAutoAnswer)).append("\n");
        sb.append("    alertingTimeoutSeconds: ").append(this.toIndentedString(this.alertingTimeoutSeconds)).append("\n");
        sb.append("    serviceLevel: ").append(this.toIndentedString(this.serviceLevel)).append("\n");
        sb.append("    autoAnswerAlertToneSeconds: ").append(this.toIndentedString(this.autoAnswerAlertToneSeconds)).append("\n");
        sb.append("    manualAnswerAlertToneSeconds: ").append(this.toIndentedString(this.manualAnswerAlertToneSeconds)).append("\n");
        sb.append("    subTypeSettings: ").append(this.toIndentedString(this.subTypeSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

