/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class MaskingRule
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private String substituteCharacter = null;
    private String definition = null;
    private Boolean enabled = null;
    private TypeEnum type = null;
    private DirectionEnum direction = null;
    private List<String> integrations = null;
    private Date dateCreated = null;
    private Date dateModified = null;

    public MaskingRule() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.integrations = new ArrayList<String>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public MaskingRule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Masking rule name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MaskingRule description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Description about masking rule.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MaskingRule substituteCharacter(String substituteCharacter) {
        this.substituteCharacter = substituteCharacter;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Replacement character for masked text character.")
    @JsonProperty(value="substituteCharacter")
    public String getSubstituteCharacter() {
        return this.substituteCharacter;
    }

    public void setSubstituteCharacter(String substituteCharacter) {
        this.substituteCharacter = substituteCharacter;
    }

    public MaskingRule definition(String definition) {
        this.definition = definition;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Definition of masking rule (a valid regex or builtin AI based mask name).")
    @JsonProperty(value="definition")
    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public MaskingRule enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="True/False")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public MaskingRule type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Masking rule type")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public MaskingRule direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="inbound/outbound")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public MaskingRule integrations(List<String> integrations) {
        this.integrations = integrations;
        return this;
    }

    @ApiModelProperty(example="null", value="Associated integration channels")
    @JsonProperty(value="integrations")
    public List<String> getIntegrations() {
        return this.integrations;
    }

    public void setIntegrations(List<String> integrations) {
        this.integrations = integrations;
    }

    @ApiModelProperty(example="null", value="Date when the rule was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Date when the rule was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaskingRule maskingRule = (MaskingRule)o;
        return Objects.equals(this.id, maskingRule.id) && Objects.equals(this.name, maskingRule.name) && Objects.equals(this.description, maskingRule.description) && Objects.equals(this.substituteCharacter, maskingRule.substituteCharacter) && Objects.equals(this.definition, maskingRule.definition) && Objects.equals(this.enabled, maskingRule.enabled) && Objects.equals((Object)this.type, (Object)maskingRule.type) && Objects.equals((Object)this.direction, (Object)maskingRule.direction) && Objects.equals(this.integrations, maskingRule.integrations) && Objects.equals(this.dateCreated, maskingRule.dateCreated) && Objects.equals(this.dateModified, maskingRule.dateModified);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.substituteCharacter, this.definition, this.enabled, this.type, this.direction, this.integrations, this.dateCreated, this.dateModified});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MaskingRule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    substituteCharacter: ").append(this.toIndentedString(this.substituteCharacter)).append("\n");
        sb.append("    definition: ").append(this.toIndentedString(this.definition)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    integrations: ").append(this.toIndentedString(this.integrations)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CUSTOM("Custom"),
        PREDEFINED("Predefined"),
        DEFAULT("Default");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

