/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.GuideVersionRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Guide
implements Serializable {
    private String id = null;
    private String name = null;
    private StatusEnum status = null;
    private SourceEnum source = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;
    private GuideVersionRef latestSavedVersion = null;
    private GuideVersionRef latestProductionReadyVersion = null;

    public Guide() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The name of the guide.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="The status of the guide.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Indicates how the guide content was generated.")
    @JsonProperty(value="source")
    public SourceEnum getSource() {
        return this.source;
    }

    @ApiModelProperty(example="null", value="The date and time the guide was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date and time the guide was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    @ApiModelProperty(example="null", value="The latest saved version of the guide.")
    @JsonProperty(value="latestSavedVersion")
    public GuideVersionRef getLatestSavedVersion() {
        return this.latestSavedVersion;
    }

    @ApiModelProperty(example="null", value="The latest production ready version of the guide.")
    @JsonProperty(value="latestProductionReadyVersion")
    public GuideVersionRef getLatestProductionReadyVersion() {
        return this.latestProductionReadyVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Guide guide = (Guide)o;
        return Objects.equals(this.id, guide.id) && Objects.equals(this.name, guide.name) && Objects.equals((Object)this.status, (Object)guide.status) && Objects.equals((Object)this.source, (Object)guide.source) && Objects.equals(this.dateCreated, guide.dateCreated) && Objects.equals(this.dateModified, guide.dateModified) && Objects.equals(this.selfUri, guide.selfUri) && Objects.equals(this.latestSavedVersion, guide.latestSavedVersion) && Objects.equals(this.latestProductionReadyVersion, guide.latestProductionReadyVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.status, this.source, this.dateCreated, this.dateModified, this.selfUri, this.latestSavedVersion, this.latestProductionReadyVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Guide {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    latestSavedVersion: ").append(this.toIndentedString(this.latestSavedVersion)).append("\n");
        sb.append("    latestProductionReadyVersion: ").append(this.toIndentedString(this.latestProductionReadyVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PUBLISHED("Published"),
        DRAFT("Draft");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SourceEnumDeserializer.class)
    public static enum SourceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MANUAL("Manual"),
        PROMPT("Prompt"),
        DOCUMENT("Document");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SourceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SourceEnum value : SourceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SourceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SourceEnumDeserializer
    extends StdDeserializer<SourceEnum> {
        public SourceEnumDeserializer() {
            super(SourceEnumDeserializer.class);
        }

        public SourceEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SourceEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

