/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.FlowPathsFlowFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FlowPathsQuery
implements Serializable {
    private CategoryEnum category = null;
    private List<FlowPathsFlowFilter> flows = null;

    public FlowPathsQuery() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.flows = new ArrayList<FlowPathsFlowFilter>();
        }
    }

    public FlowPathsQuery category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Category (use case) of the paths within a given domain.")
    @JsonProperty(value="category")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public FlowPathsQuery flows(List<FlowPathsFlowFilter> flows) {
        this.flows = flows;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of flows to query the paths result.")
    @JsonProperty(value="flows")
    public List<FlowPathsFlowFilter> getFlows() {
        return this.flows;
    }

    public void setFlows(List<FlowPathsFlowFilter> flows) {
        this.flows = flows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowPathsQuery flowPathsQuery = (FlowPathsQuery)o;
        return Objects.equals((Object)this.category, (Object)flowPathsQuery.category) && Objects.equals(this.flows, flowPathsQuery.flows);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.flows});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowPathsQuery {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    flows: ").append(this.toIndentedString(this.flows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CategoryEnumDeserializer.class)
    public static enum CategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALL("All"),
        ABANDONED("Abandoned"),
        AGENTESCALATION("AgentEscalation"),
        COMPLETE("Complete"),
        DISCONNECT("Disconnect"),
        ERROR("Error"),
        RECOGNITIONFAILURE("RecognitionFailure"),
        TRANSFER("Transfer");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CategoryEnum value : CategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CategoryEnumDeserializer
    extends StdDeserializer<CategoryEnum> {
        public CategoryEnumDeserializer() {
            super(CategoryEnumDeserializer.class);
        }

        public CategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

