/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationContentLineItem;
import com.mypurecloud.sdk.v2.model.ConversationContentReceivedReplyMessage;
import com.mypurecloud.sdk.v2.model.ConversationContentRequiredContactField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Payment Request object used to request payment from a customer.")
public class ConversationContentPaymentRequest
implements Serializable {
    private PaymentPlatformEnum paymentPlatform = null;
    private String countryCode = null;
    private String currencyCode = null;
    private Double orderTotal = null;
    private List<ConversationContentLineItem> lineItems = null;
    private List<ConversationContentLineItem> shippingOptions = null;
    private List<ConversationContentRequiredContactField> requiredContactFields = null;
    private ConversationContentReceivedReplyMessage receivedMessage = null;
    private ConversationContentReceivedReplyMessage replyMessage = null;

    public ConversationContentPaymentRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.lineItems = new ArrayList<ConversationContentLineItem>();
            this.shippingOptions = new ArrayList<ConversationContentLineItem>();
            this.requiredContactFields = new ArrayList<ConversationContentRequiredContactField>();
        }
    }

    @ApiModelProperty(example="null", required=true, value="The payment platform being used (e.g. Apple Pay)")
    @JsonProperty(value="paymentPlatform")
    public PaymentPlatformEnum getPaymentPlatform() {
        return this.paymentPlatform;
    }

    public ConversationContentPaymentRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The merchant's two-letter ISO 3166 country code.")
    @JsonProperty(value="countryCode")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public ConversationContentPaymentRequest currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The three-letter ISO 4217 currency code for the payment.")
    @JsonProperty(value="currencyCode")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public ConversationContentPaymentRequest orderTotal(Double orderTotal) {
        this.orderTotal = orderTotal;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The total price of the order.")
    @JsonProperty(value="orderTotal")
    public Double getOrderTotal() {
        return this.orderTotal;
    }

    public void setOrderTotal(Double orderTotal) {
        this.orderTotal = orderTotal;
    }

    public ConversationContentPaymentRequest lineItems(List<ConversationContentLineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    @ApiModelProperty(example="null", value="The items that make up the order.")
    @JsonProperty(value="lineItems")
    public List<ConversationContentLineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<ConversationContentLineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public ConversationContentPaymentRequest shippingOptions(List<ConversationContentLineItem> shippingOptions) {
        this.shippingOptions = shippingOptions;
        return this;
    }

    @ApiModelProperty(example="null", value="The available shipping options.")
    @JsonProperty(value="shippingOptions")
    public List<ConversationContentLineItem> getShippingOptions() {
        return this.shippingOptions;
    }

    public void setShippingOptions(List<ConversationContentLineItem> shippingOptions) {
        this.shippingOptions = shippingOptions;
    }

    public ConversationContentPaymentRequest requiredContactFields(List<ConversationContentRequiredContactField> requiredContactFields) {
        this.requiredContactFields = requiredContactFields;
        return this;
    }

    @ApiModelProperty(example="null", value="Contact fields required to complete the order.")
    @JsonProperty(value="requiredContactFields")
    public List<ConversationContentRequiredContactField> getRequiredContactFields() {
        return this.requiredContactFields;
    }

    public void setRequiredContactFields(List<ConversationContentRequiredContactField> requiredContactFields) {
        this.requiredContactFields = requiredContactFields;
    }

    public ConversationContentPaymentRequest receivedMessage(ConversationContentReceivedReplyMessage receivedMessage) {
        this.receivedMessage = receivedMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The message prompt to complete a payment transaction.")
    @JsonProperty(value="receivedMessage")
    public ConversationContentReceivedReplyMessage getReceivedMessage() {
        return this.receivedMessage;
    }

    public void setReceivedMessage(ConversationContentReceivedReplyMessage receivedMessage) {
        this.receivedMessage = receivedMessage;
    }

    public ConversationContentPaymentRequest replyMessage(ConversationContentReceivedReplyMessage replyMessage) {
        this.replyMessage = replyMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The reply message after the user has completed the payment transaction.")
    @JsonProperty(value="replyMessage")
    public ConversationContentReceivedReplyMessage getReplyMessage() {
        return this.replyMessage;
    }

    public void setReplyMessage(ConversationContentReceivedReplyMessage replyMessage) {
        this.replyMessage = replyMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContentPaymentRequest conversationContentPaymentRequest = (ConversationContentPaymentRequest)o;
        return Objects.equals((Object)this.paymentPlatform, (Object)conversationContentPaymentRequest.paymentPlatform) && Objects.equals(this.countryCode, conversationContentPaymentRequest.countryCode) && Objects.equals(this.currencyCode, conversationContentPaymentRequest.currencyCode) && Objects.equals(this.orderTotal, conversationContentPaymentRequest.orderTotal) && Objects.equals(this.lineItems, conversationContentPaymentRequest.lineItems) && Objects.equals(this.shippingOptions, conversationContentPaymentRequest.shippingOptions) && Objects.equals(this.requiredContactFields, conversationContentPaymentRequest.requiredContactFields) && Objects.equals(this.receivedMessage, conversationContentPaymentRequest.receivedMessage) && Objects.equals(this.replyMessage, conversationContentPaymentRequest.replyMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentPlatform, this.countryCode, this.currencyCode, this.orderTotal, this.lineItems, this.shippingOptions, this.requiredContactFields, this.receivedMessage, this.replyMessage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContentPaymentRequest {\n");
        sb.append("    paymentPlatform: ").append(this.toIndentedString((Object)this.paymentPlatform)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    orderTotal: ").append(this.toIndentedString(this.orderTotal)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    shippingOptions: ").append(this.toIndentedString(this.shippingOptions)).append("\n");
        sb.append("    requiredContactFields: ").append(this.toIndentedString(this.requiredContactFields)).append("\n");
        sb.append("    receivedMessage: ").append(this.toIndentedString(this.receivedMessage)).append("\n");
        sb.append("    replyMessage: ").append(this.toIndentedString(this.replyMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PaymentPlatformEnumDeserializer.class)
    public static enum PaymentPlatformEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        APPLEPAY("ApplePay");

        private String value;

        private PaymentPlatformEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PaymentPlatformEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PaymentPlatformEnum value : PaymentPlatformEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PaymentPlatformEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PaymentPlatformEnumDeserializer
    extends StdDeserializer<PaymentPlatformEnum> {
        public PaymentPlatformEnumDeserializer() {
            super(PaymentPlatformEnumDeserializer.class);
        }

        public PaymentPlatformEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PaymentPlatformEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

