/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.CreateTimeOffPlanBusinessUnitAssociation;
import com.mypurecloud.sdk.v2.model.CreateTimeOffPlanManagementUnitAssociation;
import com.mypurecloud.sdk.v2.model.HrisTimeOffType;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BuCreateTimeOffPlanRequest
implements Serializable {
    private String name = null;
    private List<String> activityCodeIds = null;
    private AutoApprovalRuleEnum autoApprovalRule = null;
    private Integer daysBeforeStartToExpireFromWaitlist = null;
    private Boolean autoPublishApprovedTimeOffRequests = null;
    private List<String> restrictedActivityCodeIds = null;
    private HrisTimeOffType hrisTimeOffType = null;
    private Boolean enabled = null;
    private Boolean countAgainstTimeOffLimits = null;
    private CreateTimeOffPlanBusinessUnitAssociation businessUnitAssociation = null;
    private CreateTimeOffPlanManagementUnitAssociation managementUnitAssociation = null;

    public BuCreateTimeOffPlanRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.activityCodeIds = new ArrayList<String>();
            this.restrictedActivityCodeIds = new ArrayList<String>();
        }
    }

    public BuCreateTimeOffPlanRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of this time-off plan")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BuCreateTimeOffPlanRequest activityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of activity codes to associate with this time-off plan")
    @JsonProperty(value="activityCodeIds")
    public List<String> getActivityCodeIds() {
        return this.activityCodeIds;
    }

    public void setActivityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
    }

    public BuCreateTimeOffPlanRequest autoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
        return this;
    }

    @ApiModelProperty(example="null", value="Auto approval rule for this time-off plan. Default is Never")
    @JsonProperty(value="autoApprovalRule")
    public AutoApprovalRuleEnum getAutoApprovalRule() {
        return this.autoApprovalRule;
    }

    public void setAutoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
    }

    public BuCreateTimeOffPlanRequest daysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of days before the time-off request start date for when the request will be expired from the waitlist. Default is 0")
    @JsonProperty(value="daysBeforeStartToExpireFromWaitlist")
    public Integer getDaysBeforeStartToExpireFromWaitlist() {
        return this.daysBeforeStartToExpireFromWaitlist;
    }

    public void setDaysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
    }

    public BuCreateTimeOffPlanRequest autoPublishApprovedTimeOffRequests(Boolean autoPublishApprovedTimeOffRequests) {
        this.autoPublishApprovedTimeOffRequests = autoPublishApprovedTimeOffRequests;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether newly approved time-off requests with activity codes associated with this time-off plan should be automatically published to the schedule")
    @JsonProperty(value="autoPublishApprovedTimeOffRequests")
    public Boolean getAutoPublishApprovedTimeOffRequests() {
        return this.autoPublishApprovedTimeOffRequests;
    }

    public void setAutoPublishApprovedTimeOffRequests(Boolean autoPublishApprovedTimeOffRequests) {
        this.autoPublishApprovedTimeOffRequests = autoPublishApprovedTimeOffRequests;
    }

    public BuCreateTimeOffPlanRequest restrictedActivityCodeIds(List<String> restrictedActivityCodeIds) {
        this.restrictedActivityCodeIds = restrictedActivityCodeIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of non time-off activity codes to check for conflicts in case the auto approval rule specifies checking activity codes. If these activity codes are present in schedule and overlap with the time-off request duration, the request will not be auto approved")
    @JsonProperty(value="restrictedActivityCodeIds")
    public List<String> getRestrictedActivityCodeIds() {
        return this.restrictedActivityCodeIds;
    }

    public void setRestrictedActivityCodeIds(List<String> restrictedActivityCodeIds) {
        this.restrictedActivityCodeIds = restrictedActivityCodeIds;
    }

    public BuCreateTimeOffPlanRequest hrisTimeOffType(HrisTimeOffType hrisTimeOffType) {
        this.hrisTimeOffType = hrisTimeOffType;
        return this;
    }

    @ApiModelProperty(example="null", value="Time-off type, if this time-off plan is associated with the integration")
    @JsonProperty(value="hrisTimeOffType")
    public HrisTimeOffType getHrisTimeOffType() {
        return this.hrisTimeOffType;
    }

    public void setHrisTimeOffType(HrisTimeOffType hrisTimeOffType) {
        this.hrisTimeOffType = hrisTimeOffType;
    }

    public BuCreateTimeOffPlanRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this time-off plan should be used by agents. Default is true")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public BuCreateTimeOffPlanRequest countAgainstTimeOffLimits(Boolean countAgainstTimeOffLimits) {
        this.countAgainstTimeOffLimits = countAgainstTimeOffLimits;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this time-off plan should count against time-off limits. Default is false")
    @JsonProperty(value="countAgainstTimeOffLimits")
    public Boolean getCountAgainstTimeOffLimits() {
        return this.countAgainstTimeOffLimits;
    }

    public void setCountAgainstTimeOffLimits(Boolean countAgainstTimeOffLimits) {
        this.countAgainstTimeOffLimits = countAgainstTimeOffLimits;
    }

    public BuCreateTimeOffPlanRequest businessUnitAssociation(CreateTimeOffPlanBusinessUnitAssociation businessUnitAssociation) {
        this.businessUnitAssociation = businessUnitAssociation;
        return this;
    }

    @ApiModelProperty(example="null", value="Business unit association, if the time-off plan belongs to a business unit. managementUnitAssociation must not be set if this is populated")
    @JsonProperty(value="businessUnitAssociation")
    public CreateTimeOffPlanBusinessUnitAssociation getBusinessUnitAssociation() {
        return this.businessUnitAssociation;
    }

    public void setBusinessUnitAssociation(CreateTimeOffPlanBusinessUnitAssociation businessUnitAssociation) {
        this.businessUnitAssociation = businessUnitAssociation;
    }

    public BuCreateTimeOffPlanRequest managementUnitAssociation(CreateTimeOffPlanManagementUnitAssociation managementUnitAssociation) {
        this.managementUnitAssociation = managementUnitAssociation;
        return this;
    }

    @ApiModelProperty(example="null", value="Management unit association, if the time-off plan belongs to a management unit. businessUnitAssociation must not be set if this is populated")
    @JsonProperty(value="managementUnitAssociation")
    public CreateTimeOffPlanManagementUnitAssociation getManagementUnitAssociation() {
        return this.managementUnitAssociation;
    }

    public void setManagementUnitAssociation(CreateTimeOffPlanManagementUnitAssociation managementUnitAssociation) {
        this.managementUnitAssociation = managementUnitAssociation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuCreateTimeOffPlanRequest buCreateTimeOffPlanRequest = (BuCreateTimeOffPlanRequest)o;
        return Objects.equals(this.name, buCreateTimeOffPlanRequest.name) && Objects.equals(this.activityCodeIds, buCreateTimeOffPlanRequest.activityCodeIds) && Objects.equals((Object)this.autoApprovalRule, (Object)buCreateTimeOffPlanRequest.autoApprovalRule) && Objects.equals(this.daysBeforeStartToExpireFromWaitlist, buCreateTimeOffPlanRequest.daysBeforeStartToExpireFromWaitlist) && Objects.equals(this.autoPublishApprovedTimeOffRequests, buCreateTimeOffPlanRequest.autoPublishApprovedTimeOffRequests) && Objects.equals(this.restrictedActivityCodeIds, buCreateTimeOffPlanRequest.restrictedActivityCodeIds) && Objects.equals(this.hrisTimeOffType, buCreateTimeOffPlanRequest.hrisTimeOffType) && Objects.equals(this.enabled, buCreateTimeOffPlanRequest.enabled) && Objects.equals(this.countAgainstTimeOffLimits, buCreateTimeOffPlanRequest.countAgainstTimeOffLimits) && Objects.equals(this.businessUnitAssociation, buCreateTimeOffPlanRequest.businessUnitAssociation) && Objects.equals(this.managementUnitAssociation, buCreateTimeOffPlanRequest.managementUnitAssociation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.activityCodeIds, this.autoApprovalRule, this.daysBeforeStartToExpireFromWaitlist, this.autoPublishApprovedTimeOffRequests, this.restrictedActivityCodeIds, this.hrisTimeOffType, this.enabled, this.countAgainstTimeOffLimits, this.businessUnitAssociation, this.managementUnitAssociation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuCreateTimeOffPlanRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    activityCodeIds: ").append(this.toIndentedString(this.activityCodeIds)).append("\n");
        sb.append("    autoApprovalRule: ").append(this.toIndentedString((Object)this.autoApprovalRule)).append("\n");
        sb.append("    daysBeforeStartToExpireFromWaitlist: ").append(this.toIndentedString(this.daysBeforeStartToExpireFromWaitlist)).append("\n");
        sb.append("    autoPublishApprovedTimeOffRequests: ").append(this.toIndentedString(this.autoPublishApprovedTimeOffRequests)).append("\n");
        sb.append("    restrictedActivityCodeIds: ").append(this.toIndentedString(this.restrictedActivityCodeIds)).append("\n");
        sb.append("    hrisTimeOffType: ").append(this.toIndentedString(this.hrisTimeOffType)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    countAgainstTimeOffLimits: ").append(this.toIndentedString(this.countAgainstTimeOffLimits)).append("\n");
        sb.append("    businessUnitAssociation: ").append(this.toIndentedString(this.businessUnitAssociation)).append("\n");
        sb.append("    managementUnitAssociation: ").append(this.toIndentedString(this.managementUnitAssociation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AutoApprovalRuleEnumDeserializer.class)
    public static enum AutoApprovalRuleEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NEVER("Never"),
        ALWAYS("Always"),
        CHECKLIMITS("CheckLimits"),
        CHECKACTIVITYCODES("CheckActivityCodes"),
        CHECKLIMITSANDACTIVITYCODES("CheckLimitsAndActivityCodes");

        private String value;

        private AutoApprovalRuleEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AutoApprovalRuleEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AutoApprovalRuleEnum value : AutoApprovalRuleEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AutoApprovalRuleEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AutoApprovalRuleEnumDeserializer
    extends StdDeserializer<AutoApprovalRuleEnum> {
        public AutoApprovalRuleEnumDeserializer() {
            super(AutoApprovalRuleEnumDeserializer.class);
        }

        public AutoApprovalRuleEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AutoApprovalRuleEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

