/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.TimeOffLimitReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AvailableTimeOffRange
implements Serializable {
    private TimeOffLimitReference timeOffLimit = null;
    private LocalDate startDate = null;
    private GranularityEnum granularity = null;
    private List<Integer> availableMinutesPerInterval = null;
    private List<Integer> waitlistedRequestsPerInterval = null;
    private Boolean waitlistEnabled = null;

    public AvailableTimeOffRange() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.availableMinutesPerInterval = new ArrayList<Integer>();
            this.waitlistedRequestsPerInterval = new ArrayList<Integer>();
        }
    }

    public AvailableTimeOffRange timeOffLimit(TimeOffLimitReference timeOffLimit) {
        this.timeOffLimit = timeOffLimit;
        return this;
    }

    @ApiModelProperty(example="null", value="The time off limit")
    @JsonProperty(value="timeOffLimit")
    public TimeOffLimitReference getTimeOffLimit() {
        return this.timeOffLimit;
    }

    public void setTimeOffLimit(TimeOffLimitReference timeOffLimit) {
        this.timeOffLimit = timeOffLimit;
    }

    public AvailableTimeOffRange startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Start date of the requested date range. The end date is determined by the size of interval list. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="startDate")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public AvailableTimeOffRange granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Granularity choice for time off limit")
    @JsonProperty(value="granularity")
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public AvailableTimeOffRange availableMinutesPerInterval(List<Integer> availableMinutesPerInterval) {
        this.availableMinutesPerInterval = availableMinutesPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of available time off values in minutes per granularity interval")
    @JsonProperty(value="availableMinutesPerInterval")
    public List<Integer> getAvailableMinutesPerInterval() {
        return this.availableMinutesPerInterval;
    }

    public void setAvailableMinutesPerInterval(List<Integer> availableMinutesPerInterval) {
        this.availableMinutesPerInterval = availableMinutesPerInterval;
    }

    public AvailableTimeOffRange waitlistedRequestsPerInterval(List<Integer> waitlistedRequestsPerInterval) {
        this.waitlistedRequestsPerInterval = waitlistedRequestsPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", value="The current number of waitlisted time off requests for every interval per granularity")
    @JsonProperty(value="waitlistedRequestsPerInterval")
    public List<Integer> getWaitlistedRequestsPerInterval() {
        return this.waitlistedRequestsPerInterval;
    }

    public void setWaitlistedRequestsPerInterval(List<Integer> waitlistedRequestsPerInterval) {
        this.waitlistedRequestsPerInterval = waitlistedRequestsPerInterval;
    }

    public AvailableTimeOffRange waitlistEnabled(Boolean waitlistEnabled) {
        this.waitlistEnabled = waitlistEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the time off request can be waitlisted")
    @JsonProperty(value="waitlistEnabled")
    public Boolean getWaitlistEnabled() {
        return this.waitlistEnabled;
    }

    public void setWaitlistEnabled(Boolean waitlistEnabled) {
        this.waitlistEnabled = waitlistEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableTimeOffRange availableTimeOffRange = (AvailableTimeOffRange)o;
        return Objects.equals(this.timeOffLimit, availableTimeOffRange.timeOffLimit) && Objects.equals(this.startDate, availableTimeOffRange.startDate) && Objects.equals((Object)this.granularity, (Object)availableTimeOffRange.granularity) && Objects.equals(this.availableMinutesPerInterval, availableTimeOffRange.availableMinutesPerInterval) && Objects.equals(this.waitlistedRequestsPerInterval, availableTimeOffRange.waitlistedRequestsPerInterval) && Objects.equals(this.waitlistEnabled, availableTimeOffRange.waitlistEnabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timeOffLimit, this.startDate, this.granularity, this.availableMinutesPerInterval, this.waitlistedRequestsPerInterval, this.waitlistEnabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AvailableTimeOffRange {\n");
        sb.append("    timeOffLimit: ").append(this.toIndentedString(this.timeOffLimit)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    availableMinutesPerInterval: ").append(this.toIndentedString(this.availableMinutesPerInterval)).append("\n");
        sb.append("    waitlistedRequestsPerInterval: ").append(this.toIndentedString(this.waitlistedRequestsPerInterval)).append("\n");
        sb.append("    waitlistEnabled: ").append(this.toIndentedString(this.waitlistEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GranularityEnumDeserializer.class)
    public static enum GranularityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAILY("Daily"),
        FIFTEENMINUTES("FifteenMinutes");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GranularityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GranularityEnum value : GranularityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GranularityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GranularityEnumDeserializer
    extends StdDeserializer<GranularityEnum> {
        public GranularityEnumDeserializer() {
            super(GranularityEnumDeserializer.class);
        }

        public GranularityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GranularityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

