/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AgentMuScheduleResult;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class AgentMuQueryResponse
implements Serializable {
    private StatusEnum status = null;
    private String operationId = null;
    private AgentMuScheduleResult result = null;
    private String downloadUrl = null;
    private ErrorBody error = null;

    public AgentMuQueryResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public AgentMuQueryResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the operation")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AgentMuQueryResponse operationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID for the operation")
    @JsonProperty(value="operationId")
    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public AgentMuQueryResponse result(AgentMuScheduleResult result) {
        this.result = result;
        return this;
    }

    @ApiModelProperty(example="null", value="The schema of the result of the operation. Null if downloadUrl is populated, but defines the schema of the data that will be returned from the downloadUrl")
    @JsonProperty(value="result")
    public AgentMuScheduleResult getResult() {
        return this.result;
    }

    public void setResult(AgentMuScheduleResult result) {
        this.result = result;
    }

    public AgentMuQueryResponse downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The URL from which to download the result. The result will follow the schema documented by the result field")
    @JsonProperty(value="downloadUrl")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public AgentMuQueryResponse error(ErrorBody error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(example="null", value="Error details if status == 'Error'. Will always be null but the schema is documented in case of an error in an async notification")
    @JsonProperty(value="error")
    public ErrorBody getError() {
        return this.error;
    }

    public void setError(ErrorBody error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentMuQueryResponse agentMuQueryResponse = (AgentMuQueryResponse)o;
        return Objects.equals((Object)this.status, (Object)agentMuQueryResponse.status) && Objects.equals(this.operationId, agentMuQueryResponse.operationId) && Objects.equals(this.result, agentMuQueryResponse.result) && Objects.equals(this.downloadUrl, agentMuQueryResponse.downloadUrl) && Objects.equals(this.error, agentMuQueryResponse.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.operationId, this.result, this.downloadUrl, this.error});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentMuQueryResponse {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    operationId: ").append(this.toIndentedString(this.operationId)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PROCESSING("Processing"),
        COMPLETE("Complete"),
        CANCELED("Canceled"),
        ERROR("Error");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

