/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class AdjustableLiveSpeakerDetection
implements Serializable {
    private ModeEnum mode = null;
    private String preconnectDuration = null;
    private String eventName = null;
    private Boolean isPersonLikely = null;
    private Integer totalRingbacks = null;
    private Boolean lineConnected = null;

    public AdjustableLiveSpeakerDetection() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public AdjustableLiveSpeakerDetection mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(example="null", value="Modes to tune between speed to live speaker detection vs accuracy.")
    @JsonProperty(value="mode")
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public AdjustableLiveSpeakerDetection preconnectDuration(String preconnectDuration) {
        this.preconnectDuration = preconnectDuration;
        return this;
    }

    @ApiModelProperty(example="null", value="ISO 8601 formatted relative duration (e.g., PT30.8427419S for 30.8 seconds), calculated on line connect.")
    @JsonProperty(value="preconnectDuration")
    public String getPreconnectDuration() {
        return this.preconnectDuration;
    }

    public void setPreconnectDuration(String preconnectDuration) {
        this.preconnectDuration = preconnectDuration;
    }

    public AdjustableLiveSpeakerDetection eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the event that triggered the ALSD evaluation (e.g., line.connect, speech.generic).")
    @JsonProperty(value="eventName")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public AdjustableLiveSpeakerDetection isPersonLikely(Boolean isPersonLikely) {
        this.isPersonLikely = isPersonLikely;
        return this;
    }

    @ApiModelProperty(example="null", value="The output of the ALSD detector, evaluating whether there is likely a person on the call based on the above inputs, and if so, a person is detected early (person disposition name and speech.person analyzer result) and the associated action taken (e.g., speech.person postconnect entry in the disposition table has the action to transfer to a queue).")
    @JsonProperty(value="isPersonLikely")
    public Boolean getIsPersonLikely() {
        return this.isPersonLikely;
    }

    public void setIsPersonLikely(Boolean isPersonLikely) {
        this.isPersonLikely = isPersonLikely;
    }

    public AdjustableLiveSpeakerDetection totalRingbacks(Integer totalRingbacks) {
        this.totalRingbacks = totalRingbacks;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of tone.ring.* analyzer events detected during the call (expected mostly during pre-connect but the last ringback tone detection could potentially complete after line connect, which will increment totalRingbacks still).")
    @JsonProperty(value="totalRingbacks")
    public Integer getTotalRingbacks() {
        return this.totalRingbacks;
    }

    public void setTotalRingbacks(Integer totalRingbacks) {
        this.totalRingbacks = totalRingbacks;
    }

    public AdjustableLiveSpeakerDetection lineConnected(Boolean lineConnected) {
        this.lineConnected = lineConnected;
        return this;
    }

    @ApiModelProperty(example="null", value="Protocol line connect received (answered by a person, machine, busy, fax).")
    @JsonProperty(value="lineConnected")
    public Boolean getLineConnected() {
        return this.lineConnected;
    }

    public void setLineConnected(Boolean lineConnected) {
        this.lineConnected = lineConnected;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdjustableLiveSpeakerDetection adjustableLiveSpeakerDetection = (AdjustableLiveSpeakerDetection)o;
        return Objects.equals((Object)this.mode, (Object)adjustableLiveSpeakerDetection.mode) && Objects.equals(this.preconnectDuration, adjustableLiveSpeakerDetection.preconnectDuration) && Objects.equals(this.eventName, adjustableLiveSpeakerDetection.eventName) && Objects.equals(this.isPersonLikely, adjustableLiveSpeakerDetection.isPersonLikely) && Objects.equals(this.totalRingbacks, adjustableLiveSpeakerDetection.totalRingbacks) && Objects.equals(this.lineConnected, adjustableLiveSpeakerDetection.lineConnected);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.preconnectDuration, this.eventName, this.isPersonLikely, this.totalRingbacks, this.lineConnected});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdjustableLiveSpeakerDetection {\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    preconnectDuration: ").append(this.toIndentedString(this.preconnectDuration)).append("\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    isPersonLikely: ").append(this.toIndentedString(this.isPersonLikely)).append("\n");
        sb.append("    totalRingbacks: ").append(this.toIndentedString(this.totalRingbacks)).append("\n");
        sb.append("    lineConnected: ").append(this.toIndentedString(this.lineConnected)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ModeEnumDeserializer.class)
    public static enum ModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("unknown"),
        DISABLED("disabled"),
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ModeEnum value : ModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ModeEnumDeserializer
    extends StdDeserializer<ModeEnum> {
        public ModeEnumDeserializer() {
            super(ModeEnumDeserializer.class);
        }

        public ModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

