/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.WorkspaceSummary;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Workspace
implements Serializable {
    private String id = null;
    private String name = null;
    private TypeEnum type = null;
    private Boolean isCurrentUserWorkspace = null;
    private DomainEntityRef user = null;
    private String bucket = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private WorkspaceSummary summary = null;
    private List<String> acl = null;
    private String description = null;
    private String selfUri = null;

    public Workspace() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.acl = new ArrayList<String>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Workspace name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The current name of the workspace.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Workspace type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Workspace isCurrentUserWorkspace(Boolean isCurrentUserWorkspace) {
        this.isCurrentUserWorkspace = isCurrentUserWorkspace;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="isCurrentUserWorkspace")
    public Boolean getIsCurrentUserWorkspace() {
        return this.isCurrentUserWorkspace;
    }

    public void setIsCurrentUserWorkspace(Boolean isCurrentUserWorkspace) {
        this.isCurrentUserWorkspace = isCurrentUserWorkspace;
    }

    public Workspace user(DomainEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="user")
    public DomainEntityRef getUser() {
        return this.user;
    }

    public void setUser(DomainEntityRef user) {
        this.user = user;
    }

    public Workspace bucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="bucket")
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public Workspace dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Workspace dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public Workspace summary(WorkspaceSummary summary) {
        this.summary = summary;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="summary")
    public WorkspaceSummary getSummary() {
        return this.summary;
    }

    public void setSummary(WorkspaceSummary summary) {
        this.summary = summary;
    }

    public Workspace acl(List<String> acl) {
        this.acl = acl;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="acl")
    public List<String> getAcl() {
        return this.acl;
    }

    public void setAcl(List<String> acl) {
        this.acl = acl;
    }

    public Workspace description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workspace workspace = (Workspace)o;
        return Objects.equals(this.id, workspace.id) && Objects.equals(this.name, workspace.name) && Objects.equals((Object)this.type, (Object)workspace.type) && Objects.equals(this.isCurrentUserWorkspace, workspace.isCurrentUserWorkspace) && Objects.equals(this.user, workspace.user) && Objects.equals(this.bucket, workspace.bucket) && Objects.equals(this.dateCreated, workspace.dateCreated) && Objects.equals(this.dateModified, workspace.dateModified) && Objects.equals(this.summary, workspace.summary) && Objects.equals(this.acl, workspace.acl) && Objects.equals(this.description, workspace.description) && Objects.equals(this.selfUri, workspace.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.type, this.isCurrentUserWorkspace, this.user, this.bucket, this.dateCreated, this.dateModified, this.summary, this.acl, this.description, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Workspace {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    isCurrentUserWorkspace: ").append(this.toIndentedString(this.isCurrentUserWorkspace)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    bucket: ").append(this.toIndentedString(this.bucket)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    acl: ").append(this.toIndentedString(this.acl)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USER("USER"),
        GROUP("GROUP");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

