/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AddShiftTradeRequest
implements Serializable {
    private String scheduleId = null;
    private String initiatingShiftId = null;
    private String receivingUserId = null;
    private Date expiration = null;
    private List<String> acceptableIntervals = null;

    public AddShiftTradeRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.acceptableIntervals = new ArrayList<String>();
        }
    }

    public AddShiftTradeRequest scheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the schedule to which the initiating and receiving shifts belong")
    @JsonProperty(value="scheduleId")
    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public AddShiftTradeRequest initiatingShiftId(String initiatingShiftId) {
        this.initiatingShiftId = initiatingShiftId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the shift that the initiating user wants to give up")
    @JsonProperty(value="initiatingShiftId")
    public String getInitiatingShiftId() {
        return this.initiatingShiftId;
    }

    public void setInitiatingShiftId(String initiatingShiftId) {
        this.initiatingShiftId = initiatingShiftId;
    }

    public AddShiftTradeRequest receivingUserId(String receivingUserId) {
        this.receivingUserId = receivingUserId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user to whom to send the request (for use in direct trade requests)")
    @JsonProperty(value="receivingUserId")
    public String getReceivingUserId() {
        return this.receivingUserId;
    }

    public void setReceivingUserId(String receivingUserId) {
        this.receivingUserId = receivingUserId;
    }

    public AddShiftTradeRequest expiration(Date expiration) {
        this.expiration = expiration;
        return this;
    }

    @ApiModelProperty(example="null", value="When this shift trade request should expire. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="expiration")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public AddShiftTradeRequest acceptableIntervals(List<String> acceptableIntervals) {
        this.acceptableIntervals = acceptableIntervals;
        return this;
    }

    @ApiModelProperty(example="null", value="The acceptable intervals the initiating user is willing to accept in trade.  Empty indicates the user is giving up the shift. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="acceptableIntervals")
    public List<String> getAcceptableIntervals() {
        return this.acceptableIntervals;
    }

    public void setAcceptableIntervals(List<String> acceptableIntervals) {
        this.acceptableIntervals = acceptableIntervals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddShiftTradeRequest addShiftTradeRequest = (AddShiftTradeRequest)o;
        return Objects.equals(this.scheduleId, addShiftTradeRequest.scheduleId) && Objects.equals(this.initiatingShiftId, addShiftTradeRequest.initiatingShiftId) && Objects.equals(this.receivingUserId, addShiftTradeRequest.receivingUserId) && Objects.equals(this.expiration, addShiftTradeRequest.expiration) && Objects.equals(this.acceptableIntervals, addShiftTradeRequest.acceptableIntervals);
    }

    public int hashCode() {
        return Objects.hash(this.scheduleId, this.initiatingShiftId, this.receivingUserId, this.expiration, this.acceptableIntervals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddShiftTradeRequest {\n");
        sb.append("    scheduleId: ").append(this.toIndentedString(this.scheduleId)).append("\n");
        sb.append("    initiatingShiftId: ").append(this.toIndentedString(this.initiatingShiftId)).append("\n");
        sb.append("    receivingUserId: ").append(this.toIndentedString(this.receivingUserId)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    acceptableIntervals: ").append(this.toIndentedString(this.acceptableIntervals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

