/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetUsersQueryRequest {
    private String cursor;
    private Integer pageSize;
    private String sortOrder;
    private List<String> expand;
    private String integrationPresenceSource;
    private String state;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public GetUsersQueryRequest withCursor(String cursor) {
        this.setCursor(cursor);
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public GetUsersQueryRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public GetUsersQueryRequest withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetUsersQueryRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public String getIntegrationPresenceSource() {
        return this.integrationPresenceSource;
    }

    public void setIntegrationPresenceSource(String integrationPresenceSource) {
        this.integrationPresenceSource = integrationPresenceSource;
    }

    public GetUsersQueryRequest withIntegrationPresenceSource(String integrationPresenceSource) {
        this.setIntegrationPresenceSource(integrationPresenceSource);
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public GetUsersQueryRequest withState(String state) {
        this.setState(state);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUsersQueryRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        return ApiRequestBuilder.create("GET", "/api/v2/users/query").withQueryParameters("cursor", "", this.cursor).withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("sortOrder", "", this.sortOrder).withQueryParameters("expand", "multi", this.expand).withQueryParameters("integrationPresenceSource", "", this.integrationPresenceSource).withQueryParameters("state", "", this.state).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final GetUsersQueryRequest request = new GetUsersQueryRequest();

        private Builder() {
        }

        public Builder withCursor(String cursor) {
            this.request.setCursor(cursor);
            return this;
        }

        public Builder withPageSize(Integer pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withSortOrder(String sortOrder) {
            this.request.setSortOrder(sortOrder);
            return this;
        }

        public Builder withSortOrder(sortOrderValues sortOrder) {
            this.request.setSortOrder(sortOrder.toString());
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withIntegrationPresenceSource(String integrationPresenceSource) {
            this.request.setIntegrationPresenceSource(integrationPresenceSource);
            return this;
        }

        public Builder withIntegrationPresenceSource(integrationPresenceSourceValues integrationPresenceSource) {
            this.request.setIntegrationPresenceSource(integrationPresenceSource.toString());
            return this;
        }

        public Builder withState(String state) {
            this.request.setState(state);
            return this;
        }

        public Builder withState(stateValues state) {
            this.request.setState(state.toString());
            return this;
        }

        public GetUsersQueryRequest build() {
            return this.request;
        }
    }

    public static enum stateValues {
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted"),
        ANY("any");

        private String value;

        private stateValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static stateValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (stateValues value : stateValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return stateValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum integrationPresenceSourceValues {
        MICROSOFTTEAMS("MicrosoftTeams"),
        ZOOMPHONE("ZoomPhone"),
        EIGHTBYEIGHT("EightByEight");

        private String value;

        private integrationPresenceSourceValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static integrationPresenceSourceValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (integrationPresenceSourceValues value : integrationPresenceSourceValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return integrationPresenceSourceValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum expandValues {
        ROUTINGSTATUS("routingStatus"),
        PRESENCE("presence"),
        INTEGRATIONPRESENCE("integrationPresence"),
        CONVERSATIONSUMMARY("conversationSummary"),
        OUTOFOFFICE("outOfOffice"),
        GEOLOCATION("geolocation"),
        STATION("station"),
        AUTHORIZATION("authorization"),
        LASTTOKENISSUED("lasttokenissued"),
        AUTHORIZATION_UNUSEDROLES("authorization.unusedRoles"),
        TEAM("team"),
        WORKPLANBIDRANKS("workPlanBidRanks"),
        EXTERNALCONTACTSSETTINGS("externalContactsSettings"),
        GROUPS("groups"),
        CUSTOMATTRIBUTES("customAttributes"),
        PROFILESKILLS("profileSkills"),
        CERTIFICATIONS("certifications"),
        LOCATIONS("locations"),
        SKILLS("skills"),
        LANGUAGES("languages"),
        LANGUAGEPREFERENCE("languagePreference"),
        EMPLOYERINFO("employerInfo"),
        BIOGRAPHY("biography"),
        DATELASTLOGIN("dateLastLogin"),
        DATEWELCOMESENT("dateWelcomeSent");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum sortOrderValues {
        ASC("ASC"),
        DESC("DESC");

        private String value;

        private sortOrderValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static sortOrderValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (sortOrderValues value : sortOrderValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return sortOrderValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

