/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.SearchAggregation;
import com.mypurecloud.sdk.v2.model.SearchCriteria;
import com.mypurecloud.sdk.v2.model.SearchSort;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SearchRequest
implements Serializable {
    private SortOrderEnum sortOrder = null;
    private String sortBy = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private List<SearchSort> sort = null;
    private List<String> returnFields = null;
    private List<String> expand = null;
    private List<String> types = null;
    private List<SearchCriteria> query = null;
    private List<SearchAggregation> aggregations = null;

    public SearchRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.sort = new ArrayList<SearchSort>();
            this.returnFields = new ArrayList<String>();
            this.expand = new ArrayList<String>();
            this.types = new ArrayList<String>();
            this.query = new ArrayList<SearchCriteria>();
            this.aggregations = new ArrayList<SearchAggregation>();
        }
    }

    public SearchRequest sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="The sort order for results")
    @JsonProperty(value="sortOrder")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public SearchRequest sortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The field in the resource that you want to sort the results by")
    @JsonProperty(value="sortBy")
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public SearchRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of results per page")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public SearchRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="The page of resources you want to retrieve")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public SearchRequest sort(List<SearchSort> sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(example="null", value="Multi-value sort order, list of multiple sort values")
    @JsonProperty(value="sort")
    public List<SearchSort> getSort() {
        return this.sort;
    }

    public void setSort(List<SearchSort> sort) {
        this.sort = sort;
    }

    public SearchRequest returnFields(List<String> returnFields) {
        this.returnFields = returnFields;
        return this;
    }

    @ApiModelProperty(example="null", value="A List of strings.  Possible values are any field in the resource you are searching on.  The other option is to use ALL_FIELDS, when this is provided all fields in the resource will be returned in the search results.")
    @JsonProperty(value="returnFields")
    public List<String> getReturnFields() {
        return this.returnFields;
    }

    public void setReturnFields(List<String> returnFields) {
        this.returnFields = returnFields;
    }

    public SearchRequest expand(List<String> expand) {
        this.expand = expand;
        return this;
    }

    @ApiModelProperty(example="null", value="Provides more details about a specified resource")
    @JsonProperty(value="expand")
    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public SearchRequest types(List<String> types) {
        this.types = types;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Resource domain type to search")
    @JsonProperty(value="types")
    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public SearchRequest query(List<SearchCriteria> query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", value="The search criteria")
    @JsonProperty(value="query")
    public List<SearchCriteria> getQuery() {
        return this.query;
    }

    public void setQuery(List<SearchCriteria> query) {
        this.query = query;
    }

    public SearchRequest aggregations(List<SearchAggregation> aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @ApiModelProperty(example="null", value="Aggregation criteria")
    @JsonProperty(value="aggregations")
    public List<SearchAggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<SearchAggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRequest searchRequest = (SearchRequest)o;
        return Objects.equals((Object)this.sortOrder, (Object)searchRequest.sortOrder) && Objects.equals(this.sortBy, searchRequest.sortBy) && Objects.equals(this.pageSize, searchRequest.pageSize) && Objects.equals(this.pageNumber, searchRequest.pageNumber) && Objects.equals(this.sort, searchRequest.sort) && Objects.equals(this.returnFields, searchRequest.returnFields) && Objects.equals(this.expand, searchRequest.expand) && Objects.equals(this.types, searchRequest.types) && Objects.equals(this.query, searchRequest.query) && Objects.equals(this.aggregations, searchRequest.aggregations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sortOrder, this.sortBy, this.pageSize, this.pageNumber, this.sort, this.returnFields, this.expand, this.types, this.query, this.aggregations});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchRequest {\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString(this.sortBy)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    returnFields: ").append(this.toIndentedString(this.returnFields)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SortOrderEnumDeserializer.class)
    public static enum SortOrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("ASC"),
        DESC("DESC"),
        SCORE("SCORE");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortOrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortOrderEnum value : SortOrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortOrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SortOrderEnumDeserializer
    extends StdDeserializer<SortOrderEnum> {
        public SortOrderEnumDeserializer() {
            super(SortOrderEnumDeserializer.class);
        }

        public SortOrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SortOrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

