/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AfterCallWork;
import com.mypurecloud.sdk.v2.model.Attachment;
import com.mypurecloud.sdk.v2.model.ConversationQueueMediaSettings;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.Segment;
import com.mypurecloud.sdk.v2.model.Wrapup;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Email
implements Serializable {
    private StateEnum state = null;
    private InitialStateEnum initialState = null;
    private String id = null;
    private Boolean held = null;
    private String subject = null;
    private Integer messagesSent = null;
    private List<Segment> segments = null;
    private DirectionEnum direction = null;
    private String recordingId = null;
    private ErrorBody errorInfo = null;
    private DisconnectTypeEnum disconnectType = null;
    private Date startHoldTime = null;
    private Date startAlertingTime = null;
    private Date connectedTime = null;
    private Date disconnectedTime = null;
    private Boolean autoGenerated = null;
    private String provider = null;
    private String scriptId = null;
    private String peerId = null;
    private String messageId = null;
    private List<Attachment> draftAttachments = null;
    private Boolean spam = null;
    private Wrapup wrapup = null;
    private AfterCallWork afterCallWork = null;
    private Boolean afterCallWorkRequired = null;
    private ConversationQueueMediaSettings queueMediaSettings = null;
    private Date parkTime = null;

    public Email() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.segments = new ArrayList<Segment>();
            this.draftAttachments = new ArrayList<Attachment>();
        }
    }

    public Email state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this communication.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Email initialState(InitialStateEnum initialState) {
        this.initialState = initialState;
        return this;
    }

    @ApiModelProperty(example="null", value="The initial connection state of this communication.")
    @JsonProperty(value="initialState")
    public InitialStateEnum getInitialState() {
        return this.initialState;
    }

    public void setInitialState(InitialStateEnum initialState) {
        this.initialState = initialState;
    }

    public Email id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Email held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is held and the person on this side hears silence.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public Email subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", value="The subject for the initial email that started this conversation.")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Email messagesSent(Integer messagesSent) {
        this.messagesSent = messagesSent;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of email messages sent by this participant.")
    @JsonProperty(value="messagesSent")
    public Integer getMessagesSent() {
        return this.messagesSent;
    }

    public void setMessagesSent(Integer messagesSent) {
        this.messagesSent = messagesSent;
    }

    public Email segments(List<Segment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", value="The time line of the participant's email, divided into activity segments.")
    @JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public Email direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the email")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public Email recordingId(String recordingId) {
        this.recordingId = recordingId;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the recording associated with this call.")
    @JsonProperty(value="recordingId")
    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public Email errorInfo(ErrorBody errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="errorInfo")
    public ErrorBody getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(ErrorBody errorInfo) {
        this.errorInfo = errorInfo;
    }

    public Email disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public Email startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the email was placed on hold in the cloud clock if the email is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public Email startAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the communication has when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startAlertingTime")
    public Date getStartAlertingTime() {
        return this.startAlertingTime;
    }

    public void setStartAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
    }

    public Email connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public Email disconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="disconnectedTime")
    public Date getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public Email autoGenerated(Boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates that the email was auto-generated like an Out of Office reply.")
    @JsonProperty(value="autoGenerated")
    public Boolean getAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(Boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    public Email provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the email.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public Email scriptId(String scriptId) {
        this.scriptId = scriptId;
        return this;
    }

    @ApiModelProperty(example="null", value="The UUID of the script to use.")
    @JsonProperty(value="scriptId")
    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public Email peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peerId")
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public Email messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the stored content of this communication.")
    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Email draftAttachments(List<Attachment> draftAttachments) {
        this.draftAttachments = draftAttachments;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of uploaded attachments on the email draft.")
    @JsonProperty(value="draftAttachments")
    public List<Attachment> getDraftAttachments() {
        return this.draftAttachments;
    }

    public void setDraftAttachments(List<Attachment> draftAttachments) {
        this.draftAttachments = draftAttachments;
    }

    public Email spam(Boolean spam) {
        this.spam = spam;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if the inbound email was marked as spam.")
    @JsonProperty(value="spam")
    public Boolean getSpam() {
        return this.spam;
    }

    public void setSpam(Boolean spam) {
        this.spam = spam;
    }

    public Email wrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Call wrap up or disposition data.")
    @JsonProperty(value="wrapup")
    public Wrapup getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
    }

    public Email afterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
        return this;
    }

    @ApiModelProperty(example="null", value="After-call work for the communication.")
    @JsonProperty(value="afterCallWork")
    public AfterCallWork getAfterCallWork() {
        return this.afterCallWork;
    }

    public void setAfterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
    }

    public Email afterCallWorkRequired(Boolean afterCallWorkRequired) {
        this.afterCallWorkRequired = afterCallWorkRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if after-call work is required for a communication. Only used when the ACW Setting is Agent Requested.")
    @JsonProperty(value="afterCallWorkRequired")
    public Boolean getAfterCallWorkRequired() {
        return this.afterCallWorkRequired;
    }

    public void setAfterCallWorkRequired(Boolean afterCallWorkRequired) {
        this.afterCallWorkRequired = afterCallWorkRequired;
    }

    public Email queueMediaSettings(ConversationQueueMediaSettings queueMediaSettings) {
        this.queueMediaSettings = queueMediaSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the queue settings for this media type.")
    @JsonProperty(value="queueMediaSettings")
    public ConversationQueueMediaSettings getQueueMediaSettings() {
        return this.queueMediaSettings;
    }

    public void setQueueMediaSettings(ConversationQueueMediaSettings queueMediaSettings) {
        this.queueMediaSettings = queueMediaSettings;
    }

    public Email parkTime(Date parkTime) {
        this.parkTime = parkTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the time when an email was put into parked state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="parkTime")
    public Date getParkTime() {
        return this.parkTime;
    }

    public void setParkTime(Date parkTime) {
        this.parkTime = parkTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Email email = (Email)o;
        return Objects.equals((Object)this.state, (Object)email.state) && Objects.equals((Object)this.initialState, (Object)email.initialState) && Objects.equals(this.id, email.id) && Objects.equals(this.held, email.held) && Objects.equals(this.subject, email.subject) && Objects.equals(this.messagesSent, email.messagesSent) && Objects.equals(this.segments, email.segments) && Objects.equals((Object)this.direction, (Object)email.direction) && Objects.equals(this.recordingId, email.recordingId) && Objects.equals(this.errorInfo, email.errorInfo) && Objects.equals((Object)this.disconnectType, (Object)email.disconnectType) && Objects.equals(this.startHoldTime, email.startHoldTime) && Objects.equals(this.startAlertingTime, email.startAlertingTime) && Objects.equals(this.connectedTime, email.connectedTime) && Objects.equals(this.disconnectedTime, email.disconnectedTime) && Objects.equals(this.autoGenerated, email.autoGenerated) && Objects.equals(this.provider, email.provider) && Objects.equals(this.scriptId, email.scriptId) && Objects.equals(this.peerId, email.peerId) && Objects.equals(this.messageId, email.messageId) && Objects.equals(this.draftAttachments, email.draftAttachments) && Objects.equals(this.spam, email.spam) && Objects.equals(this.wrapup, email.wrapup) && Objects.equals(this.afterCallWork, email.afterCallWork) && Objects.equals(this.afterCallWorkRequired, email.afterCallWorkRequired) && Objects.equals(this.queueMediaSettings, email.queueMediaSettings) && Objects.equals(this.parkTime, email.parkTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.initialState, this.id, this.held, this.subject, this.messagesSent, this.segments, this.direction, this.recordingId, this.errorInfo, this.disconnectType, this.startHoldTime, this.startAlertingTime, this.connectedTime, this.disconnectedTime, this.autoGenerated, this.provider, this.scriptId, this.peerId, this.messageId, this.draftAttachments, this.spam, this.wrapup, this.afterCallWork, this.afterCallWorkRequired, this.queueMediaSettings, this.parkTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Email {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    initialState: ").append(this.toIndentedString((Object)this.initialState)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    messagesSent: ").append(this.toIndentedString(this.messagesSent)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    recordingId: ").append(this.toIndentedString(this.recordingId)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    startAlertingTime: ").append(this.toIndentedString(this.startAlertingTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    disconnectedTime: ").append(this.toIndentedString(this.disconnectedTime)).append("\n");
        sb.append("    autoGenerated: ").append(this.toIndentedString(this.autoGenerated)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    scriptId: ").append(this.toIndentedString(this.scriptId)).append("\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("    draftAttachments: ").append(this.toIndentedString(this.draftAttachments)).append("\n");
        sb.append("    spam: ").append(this.toIndentedString(this.spam)).append("\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    afterCallWork: ").append(this.toIndentedString(this.afterCallWork)).append("\n");
        sb.append("    afterCallWorkRequired: ").append(this.toIndentedString(this.afterCallWorkRequired)).append("\n");
        sb.append("    queueMediaSettings: ").append(this.toIndentedString(this.queueMediaSettings)).append("\n");
        sb.append("    parkTime: ").append(this.toIndentedString(this.parkTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        NONE("none"),
        PARKED("parked"),
        TRANSMITTING("transmitting");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=InitialStateEnumDeserializer.class)
    public static enum InitialStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        NONE("none"),
        PARKED("parked"),
        TRANSMITTING("transmitting");

        private String value;

        private InitialStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InitialStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InitialStateEnum value : InitialStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InitialStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DisconnectTypeEnumDeserializer.class)
    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TIMEOUT("timeout"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam"),
        UNCALLABLE("uncallable");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DisconnectTypeEnumDeserializer
    extends StdDeserializer<DisconnectTypeEnum> {
        public DisconnectTypeEnumDeserializer() {
            super(DisconnectTypeEnumDeserializer.class);
        }

        public DisconnectTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DisconnectTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class InitialStateEnumDeserializer
    extends StdDeserializer<InitialStateEnum> {
        public InitialStateEnumDeserializer() {
            super(InitialStateEnumDeserializer.class);
        }

        public InitialStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return InitialStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

