/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ContestDisqualifiedAgents;
import com.mypurecloud.sdk.v2.model.ContestMetrics;
import com.mypurecloud.sdk.v2.model.ContestPrizes;
import com.mypurecloud.sdk.v2.model.ContestProfile;
import com.mypurecloud.sdk.v2.model.ContestWinners;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WritableDivision;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ContestsResponse
implements Serializable {
    private String id = null;
    private WritableDivision division = null;
    private String title = null;
    private String description = null;
    private LocalDate dateStart = null;
    private LocalDate dateEnd = null;
    private WinningCriteriaEnum winningCriteria = null;
    private Date dateAnnounced = null;
    private String announcementTimezone = null;
    private AnonymizationEnum anonymization = null;
    private List<ContestMetrics> metrics = null;
    private List<ContestPrizes> prizes = null;
    private Integer version = null;
    private UserReference createdBy = null;
    private ContestProfile profile = null;
    private List<UserReference> participants = null;
    private StatusEnum status = null;
    private Integer participantCount = null;
    private Date dateFinalized = null;
    private Date dateCancelled = null;
    private Date dateModified = null;
    private Date dateScoresModified = null;
    private List<ContestWinners> winners = null;
    private List<ContestDisqualifiedAgents> disqualifiedAgents = null;
    private String selfUri = null;

    public ContestsResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.metrics = new ArrayList<ContestMetrics>();
            this.prizes = new ArrayList<ContestPrizes>();
            this.participants = new ArrayList<UserReference>();
            this.winners = new ArrayList<ContestWinners>();
            this.disqualifiedAgents = new ArrayList<ContestDisqualifiedAgents>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ContestsResponse division(WritableDivision division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division for this performance profile associate to")
    @JsonProperty(value="division")
    public WritableDivision getDivision() {
        return this.division;
    }

    public void setDivision(WritableDivision division) {
        this.division = division;
    }

    public ContestsResponse title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest title")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ContestsResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest description")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ContestsResponse dateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="Fri Jan 12 00:00:00 UTC 2024", required=true, value="Start date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStart")
    public LocalDate getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
    }

    public ContestsResponse dateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @ApiModelProperty(example="Fri Jan 12 00:00:00 UTC 2024", required=true, value="End date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEnd")
    public LocalDate getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    public ContestsResponse winningCriteria(WinningCriteriaEnum winningCriteria) {
        this.winningCriteria = winningCriteria;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest winning criteria")
    @JsonProperty(value="winningCriteria")
    public WinningCriteriaEnum getWinningCriteria() {
        return this.winningCriteria;
    }

    public void setWinningCriteria(WinningCriteriaEnum winningCriteria) {
        this.winningCriteria = winningCriteria;
    }

    public ContestsResponse dateAnnounced(Date dateAnnounced) {
        this.dateAnnounced = dateAnnounced;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest's Announcement Datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateAnnounced")
    public Date getDateAnnounced() {
        return this.dateAnnounced;
    }

    public void setDateAnnounced(Date dateAnnounced) {
        this.dateAnnounced = dateAnnounced;
    }

    public ContestsResponse announcementTimezone(String announcementTimezone) {
        this.announcementTimezone = announcementTimezone;
        return this;
    }

    @ApiModelProperty(example="Europe/London", required=true, value="The Contest's Announcement Timezone. Valid values are strings of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London")
    @JsonProperty(value="announcementTimezone")
    public String getAnnouncementTimezone() {
        return this.announcementTimezone;
    }

    public void setAnnouncementTimezone(String announcementTimezone) {
        this.announcementTimezone = announcementTimezone;
    }

    public ContestsResponse anonymization(AnonymizationEnum anonymization) {
        this.anonymization = anonymization;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest anonymization")
    @JsonProperty(value="anonymization")
    public AnonymizationEnum getAnonymization() {
        return this.anonymization;
    }

    public void setAnonymization(AnonymizationEnum anonymization) {
        this.anonymization = anonymization;
    }

    public ContestsResponse metrics(List<ContestMetrics> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest's Metrics")
    @JsonProperty(value="metrics")
    public List<ContestMetrics> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<ContestMetrics> metrics) {
        this.metrics = metrics;
    }

    public ContestsResponse prizes(List<ContestPrizes> prizes) {
        this.prizes = prizes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest Prizes")
    @JsonProperty(value="prizes")
    public List<ContestPrizes> getPrizes() {
        return this.prizes;
    }

    public void setPrizes(List<ContestPrizes> prizes) {
        this.prizes = prizes;
    }

    public ContestsResponse version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The Contest Version")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ContestsResponse createdBy(UserReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The creator of the contest")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserReference createdBy) {
        this.createdBy = createdBy;
    }

    public ContestsResponse profile(ContestProfile profile) {
        this.profile = profile;
        return this;
    }

    @ApiModelProperty(example="null", value="The performance profile")
    @JsonProperty(value="profile")
    public ContestProfile getProfile() {
        return this.profile;
    }

    public void setProfile(ContestProfile profile) {
        this.profile = profile;
    }

    public ContestsResponse participants(List<UserReference> participants) {
        this.participants = participants;
        return this;
    }

    @ApiModelProperty(example="null", value="The Contest's participants")
    @JsonProperty(value="participants")
    public List<UserReference> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<UserReference> participants) {
        this.participants = participants;
    }

    public ContestsResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The Contest status")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ContestsResponse participantCount(Integer participantCount) {
        this.participantCount = participantCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The Number of participants in the contest")
    @JsonProperty(value="participantCount")
    public Integer getParticipantCount() {
        return this.participantCount;
    }

    public void setParticipantCount(Integer participantCount) {
        this.participantCount = participantCount;
    }

    public ContestsResponse dateFinalized(Date dateFinalized) {
        this.dateFinalized = dateFinalized;
        return this;
    }

    @ApiModelProperty(example="null", value="The Contest's finalize datetime, returned when a contest is complete. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateFinalized")
    public Date getDateFinalized() {
        return this.dateFinalized;
    }

    public void setDateFinalized(Date dateFinalized) {
        this.dateFinalized = dateFinalized;
    }

    public ContestsResponse dateCancelled(Date dateCancelled) {
        this.dateCancelled = dateCancelled;
        return this;
    }

    @ApiModelProperty(example="null", value="The Contest's cancelled datetime, returned when a contest is complete. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCancelled")
    public Date getDateCancelled() {
        return this.dateCancelled;
    }

    public void setDateCancelled(Date dateCancelled) {
        this.dateCancelled = dateCancelled;
    }

    public ContestsResponse dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The Contest's last modified datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public ContestsResponse dateScoresModified(Date dateScoresModified) {
        this.dateScoresModified = dateScoresModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The datetime the contest scores were last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateScoresModified")
    public Date getDateScoresModified() {
        return this.dateScoresModified;
    }

    public void setDateScoresModified(Date dateScoresModified) {
        this.dateScoresModified = dateScoresModified;
    }

    public ContestsResponse winners(List<ContestWinners> winners) {
        this.winners = winners;
        return this;
    }

    @ApiModelProperty(example="null", value="The Contest Winners")
    @JsonProperty(value="winners")
    public List<ContestWinners> getWinners() {
        return this.winners;
    }

    public void setWinners(List<ContestWinners> winners) {
        this.winners = winners;
    }

    public ContestsResponse disqualifiedAgents(List<ContestDisqualifiedAgents> disqualifiedAgents) {
        this.disqualifiedAgents = disqualifiedAgents;
        return this;
    }

    @ApiModelProperty(example="null", value="The Contest's disqualified agents, returned when a contest is complete")
    @JsonProperty(value="disqualifiedAgents")
    public List<ContestDisqualifiedAgents> getDisqualifiedAgents() {
        return this.disqualifiedAgents;
    }

    public void setDisqualifiedAgents(List<ContestDisqualifiedAgents> disqualifiedAgents) {
        this.disqualifiedAgents = disqualifiedAgents;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContestsResponse contestsResponse = (ContestsResponse)o;
        return Objects.equals(this.id, contestsResponse.id) && Objects.equals(this.division, contestsResponse.division) && Objects.equals(this.title, contestsResponse.title) && Objects.equals(this.description, contestsResponse.description) && Objects.equals(this.dateStart, contestsResponse.dateStart) && Objects.equals(this.dateEnd, contestsResponse.dateEnd) && Objects.equals((Object)this.winningCriteria, (Object)contestsResponse.winningCriteria) && Objects.equals(this.dateAnnounced, contestsResponse.dateAnnounced) && Objects.equals(this.announcementTimezone, contestsResponse.announcementTimezone) && Objects.equals((Object)this.anonymization, (Object)contestsResponse.anonymization) && Objects.equals(this.metrics, contestsResponse.metrics) && Objects.equals(this.prizes, contestsResponse.prizes) && Objects.equals(this.version, contestsResponse.version) && Objects.equals(this.createdBy, contestsResponse.createdBy) && Objects.equals(this.profile, contestsResponse.profile) && Objects.equals(this.participants, contestsResponse.participants) && Objects.equals((Object)this.status, (Object)contestsResponse.status) && Objects.equals(this.participantCount, contestsResponse.participantCount) && Objects.equals(this.dateFinalized, contestsResponse.dateFinalized) && Objects.equals(this.dateCancelled, contestsResponse.dateCancelled) && Objects.equals(this.dateModified, contestsResponse.dateModified) && Objects.equals(this.dateScoresModified, contestsResponse.dateScoresModified) && Objects.equals(this.winners, contestsResponse.winners) && Objects.equals(this.disqualifiedAgents, contestsResponse.disqualifiedAgents) && Objects.equals(this.selfUri, contestsResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.division, this.title, this.description, this.dateStart, this.dateEnd, this.winningCriteria, this.dateAnnounced, this.announcementTimezone, this.anonymization, this.metrics, this.prizes, this.version, this.createdBy, this.profile, this.participants, this.status, this.participantCount, this.dateFinalized, this.dateCancelled, this.dateModified, this.dateScoresModified, this.winners, this.disqualifiedAgents, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContestsResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    winningCriteria: ").append(this.toIndentedString((Object)this.winningCriteria)).append("\n");
        sb.append("    dateAnnounced: ").append(this.toIndentedString(this.dateAnnounced)).append("\n");
        sb.append("    announcementTimezone: ").append(this.toIndentedString(this.announcementTimezone)).append("\n");
        sb.append("    anonymization: ").append(this.toIndentedString((Object)this.anonymization)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    prizes: ").append(this.toIndentedString(this.prizes)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    participantCount: ").append(this.toIndentedString(this.participantCount)).append("\n");
        sb.append("    dateFinalized: ").append(this.toIndentedString(this.dateFinalized)).append("\n");
        sb.append("    dateCancelled: ").append(this.toIndentedString(this.dateCancelled)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    dateScoresModified: ").append(this.toIndentedString(this.dateScoresModified)).append("\n");
        sb.append("    winners: ").append(this.toIndentedString(this.winners)).append("\n");
        sb.append("    disqualifiedAgents: ").append(this.toIndentedString(this.disqualifiedAgents)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=WinningCriteriaEnumDeserializer.class)
    public static enum WinningCriteriaEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HIGHESTOVERALLSCORE("HighestOverallScore"),
        HIGHESTOVERALLPERCENTOFGOAL("HighestOverallPercentOfGoal");

        private String value;

        private WinningCriteriaEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static WinningCriteriaEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (WinningCriteriaEnum value : WinningCriteriaEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return WinningCriteriaEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=AnonymizationEnumDeserializer.class)
    public static enum AnonymizationEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NOANONYMIZATION("NoAnonymization"),
        ALL("All"),
        ALLEXCEPTTOP("AllExceptTop");

        private String value;

        private AnonymizationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AnonymizationEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AnonymizationEnum value : AnonymizationEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AnonymizationEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UPCOMING("Upcoming"),
        ONGOING("Ongoing"),
        PENDING("Pending"),
        RECENTLYCOMPLETED("RecentlyCompleted"),
        COMPLETED("Completed"),
        CANCELLED("Cancelled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class AnonymizationEnumDeserializer
    extends StdDeserializer<AnonymizationEnum> {
        public AnonymizationEnumDeserializer() {
            super(AnonymizationEnumDeserializer.class);
        }

        public AnonymizationEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AnonymizationEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class WinningCriteriaEnumDeserializer
    extends StdDeserializer<WinningCriteriaEnum> {
        public WinningCriteriaEnumDeserializer() {
            super(WinningCriteriaEnumDeserializer.class);
        }

        public WinningCriteriaEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return WinningCriteriaEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

