/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ServiceLevel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CallbackMediaSettings
implements Serializable {
    private Boolean enableAutoAnswer = null;
    private Integer alertingTimeoutSeconds = null;
    private ServiceLevel serviceLevel = null;
    private Double autoAnswerAlertToneSeconds = null;
    private Double manualAnswerAlertToneSeconds = null;
    private ModeEnum mode = null;
    private Boolean enableAutoDialAndEnd = null;
    private Integer autoDialDelaySeconds = null;
    private Integer autoEndDelaySeconds = null;
    private Double pacingModifier = null;
    private Integer maxRetryCount = null;
    private Integer retryDelaySeconds = null;
    private LiveVoiceReactionTypeEnum liveVoiceReactionType = null;
    private DomainEntityRef liveVoiceFlow = null;
    private AnsweringMachineReactionTypeEnum answeringMachineReactionType = null;
    private DomainEntityRef answeringMachineFlow = null;

    public CallbackMediaSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CallbackMediaSettings enableAutoAnswer(Boolean enableAutoAnswer) {
        this.enableAutoAnswer = enableAutoAnswer;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if auto-answer is enabled for the given media type or subtype (default is false).  Subtype settings take precedence over media type settings.")
    @JsonProperty(value="enableAutoAnswer")
    public Boolean getEnableAutoAnswer() {
        return this.enableAutoAnswer;
    }

    public void setEnableAutoAnswer(Boolean enableAutoAnswer) {
        this.enableAutoAnswer = enableAutoAnswer;
    }

    public CallbackMediaSettings alertingTimeoutSeconds(Integer alertingTimeoutSeconds) {
        this.alertingTimeoutSeconds = alertingTimeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The alerting timeout for the media type, in seconds")
    @JsonProperty(value="alertingTimeoutSeconds")
    public Integer getAlertingTimeoutSeconds() {
        return this.alertingTimeoutSeconds;
    }

    public void setAlertingTimeoutSeconds(Integer alertingTimeoutSeconds) {
        this.alertingTimeoutSeconds = alertingTimeoutSeconds;
    }

    public CallbackMediaSettings serviceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    @ApiModelProperty(example="null", value="The targeted service level for the media type")
    @JsonProperty(value="serviceLevel")
    public ServiceLevel getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public CallbackMediaSettings autoAnswerAlertToneSeconds(Double autoAnswerAlertToneSeconds) {
        this.autoAnswerAlertToneSeconds = autoAnswerAlertToneSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="How long to play the alerting tone for an auto-answer interaction")
    @JsonProperty(value="autoAnswerAlertToneSeconds")
    public Double getAutoAnswerAlertToneSeconds() {
        return this.autoAnswerAlertToneSeconds;
    }

    public void setAutoAnswerAlertToneSeconds(Double autoAnswerAlertToneSeconds) {
        this.autoAnswerAlertToneSeconds = autoAnswerAlertToneSeconds;
    }

    public CallbackMediaSettings manualAnswerAlertToneSeconds(Double manualAnswerAlertToneSeconds) {
        this.manualAnswerAlertToneSeconds = manualAnswerAlertToneSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="How long to play the alerting tone for a manual-answer interaction")
    @JsonProperty(value="manualAnswerAlertToneSeconds")
    public Double getManualAnswerAlertToneSeconds() {
        return this.manualAnswerAlertToneSeconds;
    }

    public void setManualAnswerAlertToneSeconds(Double manualAnswerAlertToneSeconds) {
        this.manualAnswerAlertToneSeconds = manualAnswerAlertToneSeconds;
    }

    public CallbackMediaSettings mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(example="null", value="The mode callbacks will use on this queue.")
    @JsonProperty(value="mode")
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public CallbackMediaSettings enableAutoDialAndEnd(Boolean enableAutoDialAndEnd) {
        this.enableAutoDialAndEnd = enableAutoDialAndEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag to enable Auto-Dial and Auto-End automation for callbacks on this queue.")
    @JsonProperty(value="enableAutoDialAndEnd")
    public Boolean getEnableAutoDialAndEnd() {
        return this.enableAutoDialAndEnd;
    }

    public void setEnableAutoDialAndEnd(Boolean enableAutoDialAndEnd) {
        this.enableAutoDialAndEnd = enableAutoDialAndEnd;
    }

    public CallbackMediaSettings autoDialDelaySeconds(Integer autoDialDelaySeconds) {
        this.autoDialDelaySeconds = autoDialDelaySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Time in seconds after agent connects to callback before outgoing call is auto-dialed. Allowable values in range 0 - 1200 seconds. Defaults to 300 seconds.")
    @JsonProperty(value="autoDialDelaySeconds")
    public Integer getAutoDialDelaySeconds() {
        return this.autoDialDelaySeconds;
    }

    public void setAutoDialDelaySeconds(Integer autoDialDelaySeconds) {
        this.autoDialDelaySeconds = autoDialDelaySeconds;
    }

    public CallbackMediaSettings autoEndDelaySeconds(Integer autoEndDelaySeconds) {
        this.autoEndDelaySeconds = autoEndDelaySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Time in seconds after agent disconnects from the outgoing call before the encasing callback is auto-ended. Allowable values in range 0 - 1200 seconds. Defaults to 300 seconds.")
    @JsonProperty(value="autoEndDelaySeconds")
    public Integer getAutoEndDelaySeconds() {
        return this.autoEndDelaySeconds;
    }

    public void setAutoEndDelaySeconds(Integer autoEndDelaySeconds) {
        this.autoEndDelaySeconds = autoEndDelaySeconds;
    }

    public CallbackMediaSettings pacingModifier(Double pacingModifier) {
        this.pacingModifier = pacingModifier;
        return this;
    }

    @ApiModelProperty(example="null", value="Controls the maximum number of outbound calls at one time when mode is CustomerFirst.")
    @JsonProperty(value="pacingModifier")
    public Double getPacingModifier() {
        return this.pacingModifier;
    }

    public void setPacingModifier(Double pacingModifier) {
        this.pacingModifier = pacingModifier;
    }

    public CallbackMediaSettings maxRetryCount(Integer maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum number of retries that should be attempted to try and connect a customer first callback to a customer when the initial callback attempt did not connect.")
    @JsonProperty(value="maxRetryCount")
    public Integer getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(Integer maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public CallbackMediaSettings retryDelaySeconds(Integer retryDelaySeconds) {
        this.retryDelaySeconds = retryDelaySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Delay in seconds between each retry of a customer first callback.")
    @JsonProperty(value="retryDelaySeconds")
    public Integer getRetryDelaySeconds() {
        return this.retryDelaySeconds;
    }

    public void setRetryDelaySeconds(Integer retryDelaySeconds) {
        this.retryDelaySeconds = retryDelaySeconds;
    }

    public CallbackMediaSettings liveVoiceReactionType(LiveVoiceReactionTypeEnum liveVoiceReactionType) {
        this.liveVoiceReactionType = liveVoiceReactionType;
        return this;
    }

    @ApiModelProperty(example="null", value="The action to take if a live voice is detected during the outbound call of a customer first callback.")
    @JsonProperty(value="liveVoiceReactionType")
    public LiveVoiceReactionTypeEnum getLiveVoiceReactionType() {
        return this.liveVoiceReactionType;
    }

    public void setLiveVoiceReactionType(LiveVoiceReactionTypeEnum liveVoiceReactionType) {
        this.liveVoiceReactionType = liveVoiceReactionType;
    }

    public CallbackMediaSettings liveVoiceFlow(DomainEntityRef liveVoiceFlow) {
        this.liveVoiceFlow = liveVoiceFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The inbound flow to transfer to if a live voice is detected during the outbound call of a customer first callback.")
    @JsonProperty(value="liveVoiceFlow")
    public DomainEntityRef getLiveVoiceFlow() {
        return this.liveVoiceFlow;
    }

    public void setLiveVoiceFlow(DomainEntityRef liveVoiceFlow) {
        this.liveVoiceFlow = liveVoiceFlow;
    }

    public CallbackMediaSettings answeringMachineReactionType(AnsweringMachineReactionTypeEnum answeringMachineReactionType) {
        this.answeringMachineReactionType = answeringMachineReactionType;
        return this;
    }

    @ApiModelProperty(example="null", value="The action to take if an answering machine is detected during the outbound call of a customer first callback.")
    @JsonProperty(value="answeringMachineReactionType")
    public AnsweringMachineReactionTypeEnum getAnsweringMachineReactionType() {
        return this.answeringMachineReactionType;
    }

    public void setAnsweringMachineReactionType(AnsweringMachineReactionTypeEnum answeringMachineReactionType) {
        this.answeringMachineReactionType = answeringMachineReactionType;
    }

    public CallbackMediaSettings answeringMachineFlow(DomainEntityRef answeringMachineFlow) {
        this.answeringMachineFlow = answeringMachineFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The inbound flow to transfer to if an answering machine is detected during the outbound call of a customer first callback when answeringMachineReactionType is set to TransferToFlow.")
    @JsonProperty(value="answeringMachineFlow")
    public DomainEntityRef getAnsweringMachineFlow() {
        return this.answeringMachineFlow;
    }

    public void setAnsweringMachineFlow(DomainEntityRef answeringMachineFlow) {
        this.answeringMachineFlow = answeringMachineFlow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallbackMediaSettings callbackMediaSettings = (CallbackMediaSettings)o;
        return Objects.equals(this.enableAutoAnswer, callbackMediaSettings.enableAutoAnswer) && Objects.equals(this.alertingTimeoutSeconds, callbackMediaSettings.alertingTimeoutSeconds) && Objects.equals(this.serviceLevel, callbackMediaSettings.serviceLevel) && Objects.equals(this.autoAnswerAlertToneSeconds, callbackMediaSettings.autoAnswerAlertToneSeconds) && Objects.equals(this.manualAnswerAlertToneSeconds, callbackMediaSettings.manualAnswerAlertToneSeconds) && Objects.equals((Object)this.mode, (Object)callbackMediaSettings.mode) && Objects.equals(this.enableAutoDialAndEnd, callbackMediaSettings.enableAutoDialAndEnd) && Objects.equals(this.autoDialDelaySeconds, callbackMediaSettings.autoDialDelaySeconds) && Objects.equals(this.autoEndDelaySeconds, callbackMediaSettings.autoEndDelaySeconds) && Objects.equals(this.pacingModifier, callbackMediaSettings.pacingModifier) && Objects.equals(this.maxRetryCount, callbackMediaSettings.maxRetryCount) && Objects.equals(this.retryDelaySeconds, callbackMediaSettings.retryDelaySeconds) && Objects.equals((Object)this.liveVoiceReactionType, (Object)callbackMediaSettings.liveVoiceReactionType) && Objects.equals(this.liveVoiceFlow, callbackMediaSettings.liveVoiceFlow) && Objects.equals((Object)this.answeringMachineReactionType, (Object)callbackMediaSettings.answeringMachineReactionType) && Objects.equals(this.answeringMachineFlow, callbackMediaSettings.answeringMachineFlow);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enableAutoAnswer, this.alertingTimeoutSeconds, this.serviceLevel, this.autoAnswerAlertToneSeconds, this.manualAnswerAlertToneSeconds, this.mode, this.enableAutoDialAndEnd, this.autoDialDelaySeconds, this.autoEndDelaySeconds, this.pacingModifier, this.maxRetryCount, this.retryDelaySeconds, this.liveVoiceReactionType, this.liveVoiceFlow, this.answeringMachineReactionType, this.answeringMachineFlow});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallbackMediaSettings {\n");
        sb.append("    enableAutoAnswer: ").append(this.toIndentedString(this.enableAutoAnswer)).append("\n");
        sb.append("    alertingTimeoutSeconds: ").append(this.toIndentedString(this.alertingTimeoutSeconds)).append("\n");
        sb.append("    serviceLevel: ").append(this.toIndentedString(this.serviceLevel)).append("\n");
        sb.append("    autoAnswerAlertToneSeconds: ").append(this.toIndentedString(this.autoAnswerAlertToneSeconds)).append("\n");
        sb.append("    manualAnswerAlertToneSeconds: ").append(this.toIndentedString(this.manualAnswerAlertToneSeconds)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    enableAutoDialAndEnd: ").append(this.toIndentedString(this.enableAutoDialAndEnd)).append("\n");
        sb.append("    autoDialDelaySeconds: ").append(this.toIndentedString(this.autoDialDelaySeconds)).append("\n");
        sb.append("    autoEndDelaySeconds: ").append(this.toIndentedString(this.autoEndDelaySeconds)).append("\n");
        sb.append("    pacingModifier: ").append(this.toIndentedString(this.pacingModifier)).append("\n");
        sb.append("    maxRetryCount: ").append(this.toIndentedString(this.maxRetryCount)).append("\n");
        sb.append("    retryDelaySeconds: ").append(this.toIndentedString(this.retryDelaySeconds)).append("\n");
        sb.append("    liveVoiceReactionType: ").append(this.toIndentedString((Object)this.liveVoiceReactionType)).append("\n");
        sb.append("    liveVoiceFlow: ").append(this.toIndentedString(this.liveVoiceFlow)).append("\n");
        sb.append("    answeringMachineReactionType: ").append(this.toIndentedString((Object)this.answeringMachineReactionType)).append("\n");
        sb.append("    answeringMachineFlow: ").append(this.toIndentedString(this.answeringMachineFlow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ModeEnumDeserializer.class)
    public static enum ModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AGENTFIRST("AgentFirst"),
        CUSTOMERFIRST("CustomerFirst");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ModeEnum value : ModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=LiveVoiceReactionTypeEnumDeserializer.class)
    public static enum LiveVoiceReactionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HANGUP("HangUp"),
        TRANSFERTOQUEUE("TransferToQueue"),
        TRANSFERTOFLOW("TransferToFlow");

        private String value;

        private LiveVoiceReactionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LiveVoiceReactionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LiveVoiceReactionTypeEnum value : LiveVoiceReactionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LiveVoiceReactionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=AnsweringMachineReactionTypeEnumDeserializer.class)
    public static enum AnsweringMachineReactionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HANGUP("HangUp"),
        TRANSFERTOQUEUE("TransferToQueue"),
        TRANSFERTOFLOW("TransferToFlow");

        private String value;

        private AnsweringMachineReactionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AnsweringMachineReactionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AnsweringMachineReactionTypeEnum value : AnsweringMachineReactionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AnsweringMachineReactionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AnsweringMachineReactionTypeEnumDeserializer
    extends StdDeserializer<AnsweringMachineReactionTypeEnum> {
        public AnsweringMachineReactionTypeEnumDeserializer() {
            super(AnsweringMachineReactionTypeEnumDeserializer.class);
        }

        public AnsweringMachineReactionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AnsweringMachineReactionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class LiveVoiceReactionTypeEnumDeserializer
    extends StdDeserializer<LiveVoiceReactionTypeEnum> {
        public LiveVoiceReactionTypeEnumDeserializer() {
            super(LiveVoiceReactionTypeEnumDeserializer.class);
        }

        public LiveVoiceReactionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LiveVoiceReactionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ModeEnumDeserializer
    extends StdDeserializer<ModeEnum> {
        public ModeEnumDeserializer() {
            super(ModeEnumDeserializer.class);
        }

        public ModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

