/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UpdateGuideVersion;
import java.util.HashMap;
import java.util.Map;

public class PatchGuideVersionRequest {
    private String guideId;
    private String versionId;
    private UpdateGuideVersion body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGuideId() {
        return this.guideId;
    }

    public void setGuideId(String guideId) {
        this.guideId = guideId;
    }

    public PatchGuideVersionRequest withGuideId(String guideId) {
        this.setGuideId(guideId);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public PatchGuideVersionRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public UpdateGuideVersion getBody() {
        return this.body;
    }

    public void setBody(UpdateGuideVersion body) {
        this.body = body;
    }

    public PatchGuideVersionRequest withBody(UpdateGuideVersion body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchGuideVersionRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UpdateGuideVersion> withHttpInfo() {
        if (this.guideId == null) {
            throw new IllegalStateException("Missing the required parameter 'guideId' when building request for PatchGuideVersionRequest.");
        }
        if (this.versionId == null) {
            throw new IllegalStateException("Missing the required parameter 'versionId' when building request for PatchGuideVersionRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchGuideVersionRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/guides/{guideId}/versions/{versionId}").withPathParameter("guideId", this.guideId).withPathParameter("versionId", this.versionId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String guideId, String versionId, UpdateGuideVersion body) {
        return new Builder().withRequiredParams(guideId, versionId, body);
    }

    public static class Builder {
        private final PatchGuideVersionRequest request = new PatchGuideVersionRequest();

        private Builder() {
        }

        public Builder withGuideId(String guideId) {
            this.request.setGuideId(guideId);
            return this;
        }

        public Builder withVersionId(String versionId) {
            this.request.setVersionId(versionId);
            return this;
        }

        public Builder withBody(UpdateGuideVersion body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String guideId, String versionId, UpdateGuideVersion body) {
            this.request.setGuideId(guideId);
            this.request.setVersionId(versionId);
            this.request.setBody(body);
            return this;
        }

        public PatchGuideVersionRequest build() {
            if (this.request.guideId == null) {
                throw new IllegalStateException("Missing the required parameter 'guideId' when building request for PatchGuideVersionRequest.");
            }
            if (this.request.versionId == null) {
                throw new IllegalStateException("Missing the required parameter 'versionId' when building request for PatchGuideVersionRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchGuideVersionRequest.");
            }
            return this.request;
        }
    }
}

