/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UpdateGuide;
import java.util.HashMap;
import java.util.Map;

public class PatchGuideRequest {
    private String guideId;
    private UpdateGuide body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGuideId() {
        return this.guideId;
    }

    public void setGuideId(String guideId) {
        this.guideId = guideId;
    }

    public PatchGuideRequest withGuideId(String guideId) {
        this.setGuideId(guideId);
        return this;
    }

    public UpdateGuide getBody() {
        return this.body;
    }

    public void setBody(UpdateGuide body) {
        this.body = body;
    }

    public PatchGuideRequest withBody(UpdateGuide body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchGuideRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UpdateGuide> withHttpInfo() {
        if (this.guideId == null) {
            throw new IllegalStateException("Missing the required parameter 'guideId' when building request for PatchGuideRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchGuideRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/guides/{guideId}").withPathParameter("guideId", this.guideId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String guideId, UpdateGuide body) {
        return new Builder().withRequiredParams(guideId, body);
    }

    public static class Builder {
        private final PatchGuideRequest request = new PatchGuideRequest();

        private Builder() {
        }

        public Builder withGuideId(String guideId) {
            this.request.setGuideId(guideId);
            return this;
        }

        public Builder withBody(UpdateGuide body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String guideId, UpdateGuide body) {
            this.request.setGuideId(guideId);
            this.request.setBody(body);
            return this;
        }

        public PatchGuideRequest build() {
            if (this.request.guideId == null) {
                throw new IllegalStateException("Missing the required parameter 'guideId' when building request for PatchGuideRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchGuideRequest.");
            }
            return this.request;
        }
    }
}

