/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class WebChatMemberInfo
implements Serializable {
    private String id = null;
    private String displayName = null;
    private String firstName = null;
    private String lastName = null;
    private String email = null;
    private String phoneNumber = null;
    private String avatarImageUrl = null;
    private RoleEnum role = null;
    private Date joinDate = null;
    private Date leaveDate = null;
    private Boolean authenticatedGuest = null;
    private Map<String, String> customFields = null;
    private StateEnum state = null;

    public WebChatMemberInfo() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public WebChatMemberInfo id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The communicationId of this member.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WebChatMemberInfo displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", value="The display name of the member.")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public WebChatMemberInfo firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(example="null", value="The first name of the member.")
    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public WebChatMemberInfo lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(example="null", value="The last name of the member.")
    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public WebChatMemberInfo email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="null", value="The email address of the member.")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public WebChatMemberInfo phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="The phone number of the member.")
    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public WebChatMemberInfo avatarImageUrl(String avatarImageUrl) {
        this.avatarImageUrl = avatarImageUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The url to the avatar image of the member.")
    @JsonProperty(value="avatarImageUrl")
    public String getAvatarImageUrl() {
        return this.avatarImageUrl;
    }

    public void setAvatarImageUrl(String avatarImageUrl) {
        this.avatarImageUrl = avatarImageUrl;
    }

    public WebChatMemberInfo role(RoleEnum role) {
        this.role = role;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The role of the member, one of [agent, customer, acd, workflow]")
    @JsonProperty(value="role")
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public WebChatMemberInfo joinDate(Date joinDate) {
        this.joinDate = joinDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The time the member joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="joinDate")
    public Date getJoinDate() {
        return this.joinDate;
    }

    public void setJoinDate(Date joinDate) {
        this.joinDate = joinDate;
    }

    public WebChatMemberInfo leaveDate(Date leaveDate) {
        this.leaveDate = leaveDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The time the member left the conversation, or null if the member is still active in the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="leaveDate")
    public Date getLeaveDate() {
        return this.leaveDate;
    }

    public void setLeaveDate(Date leaveDate) {
        this.leaveDate = leaveDate;
    }

    public WebChatMemberInfo authenticatedGuest(Boolean authenticatedGuest) {
        this.authenticatedGuest = authenticatedGuest;
        return this;
    }

    @ApiModelProperty(example="null", value="If true, the guest member is an authenticated guest.")
    @JsonProperty(value="authenticatedGuest")
    public Boolean getAuthenticatedGuest() {
        return this.authenticatedGuest;
    }

    public void setAuthenticatedGuest(Boolean authenticatedGuest) {
        this.authenticatedGuest = authenticatedGuest;
    }

    public WebChatMemberInfo customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    @ApiModelProperty(example="null", value="Any custom fields of information pertaining to this member.")
    @JsonProperty(value="customFields")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public WebChatMemberInfo state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this member.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebChatMemberInfo webChatMemberInfo = (WebChatMemberInfo)o;
        return Objects.equals(this.id, webChatMemberInfo.id) && Objects.equals(this.displayName, webChatMemberInfo.displayName) && Objects.equals(this.firstName, webChatMemberInfo.firstName) && Objects.equals(this.lastName, webChatMemberInfo.lastName) && Objects.equals(this.email, webChatMemberInfo.email) && Objects.equals(this.phoneNumber, webChatMemberInfo.phoneNumber) && Objects.equals(this.avatarImageUrl, webChatMemberInfo.avatarImageUrl) && Objects.equals((Object)this.role, (Object)webChatMemberInfo.role) && Objects.equals(this.joinDate, webChatMemberInfo.joinDate) && Objects.equals(this.leaveDate, webChatMemberInfo.leaveDate) && Objects.equals(this.authenticatedGuest, webChatMemberInfo.authenticatedGuest) && Objects.equals(this.customFields, webChatMemberInfo.customFields) && Objects.equals((Object)this.state, (Object)webChatMemberInfo.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.displayName, this.firstName, this.lastName, this.email, this.phoneNumber, this.avatarImageUrl, this.role, this.joinDate, this.leaveDate, this.authenticatedGuest, this.customFields, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebChatMemberInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    avatarImageUrl: ").append(this.toIndentedString(this.avatarImageUrl)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    joinDate: ").append(this.toIndentedString(this.joinDate)).append("\n");
        sb.append("    leaveDate: ").append(this.toIndentedString(this.leaveDate)).append("\n");
        sb.append("    authenticatedGuest: ").append(this.toIndentedString(this.authenticatedGuest)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RoleEnumDeserializer.class)
    public static enum RoleEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AGENT("AGENT"),
        CUSTOMER("CUSTOMER"),
        WORKFLOW("WORKFLOW"),
        ACD("ACD");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RoleEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RoleEnum value : RoleEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RoleEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONNECTED("CONNECTED"),
        DISCONNECTED("DISCONNECTED"),
        ALERTING("ALERTING");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class RoleEnumDeserializer
    extends StdDeserializer<RoleEnum> {
        public RoleEnumDeserializer() {
            super(RoleEnumDeserializer.class);
        }

        public RoleEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RoleEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

