/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Object representing the guest model of a media request of a chat conversation.")
public class WebChatGuestMediaRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private List<TypesEnum> types = null;
    private StateEnum state = null;
    private String communicationId = null;
    private String securityKey = null;
    private String selfUri = null;

    public WebChatGuestMediaRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.types = new ArrayList<TypesEnum>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WebChatGuestMediaRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WebChatGuestMediaRequest types(List<TypesEnum> types) {
        this.types = types;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The types of media being requested.")
    @JsonProperty(value="types")
    public List<TypesEnum> getTypes() {
        return this.types;
    }

    public void setTypes(List<TypesEnum> types) {
        this.types = types;
    }

    public WebChatGuestMediaRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of the media request, one of PENDING|ACCEPTED|DECLINED|TIMEDOUT|CANCELLED|ERRORED.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public WebChatGuestMediaRequest communicationId(String communicationId) {
        this.communicationId = communicationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the new media communication, if applicable.")
    @JsonProperty(value="communicationId")
    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public WebChatGuestMediaRequest securityKey(String securityKey) {
        this.securityKey = securityKey;
        return this;
    }

    @ApiModelProperty(example="null", value="The security information related to a media request.")
    @JsonProperty(value="securityKey")
    public String getSecurityKey() {
        return this.securityKey;
    }

    public void setSecurityKey(String securityKey) {
        this.securityKey = securityKey;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebChatGuestMediaRequest webChatGuestMediaRequest = (WebChatGuestMediaRequest)o;
        return Objects.equals(this.id, webChatGuestMediaRequest.id) && Objects.equals(this.name, webChatGuestMediaRequest.name) && Objects.equals(this.types, webChatGuestMediaRequest.types) && Objects.equals((Object)this.state, (Object)webChatGuestMediaRequest.state) && Objects.equals(this.communicationId, webChatGuestMediaRequest.communicationId) && Objects.equals(this.securityKey, webChatGuestMediaRequest.securityKey) && Objects.equals(this.selfUri, webChatGuestMediaRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.types, this.state, this.communicationId, this.securityKey, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebChatGuestMediaRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    communicationId: ").append(this.toIndentedString(this.communicationId)).append("\n");
        sb.append("    securityKey: ").append(this.toIndentedString(this.securityKey)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("PENDING"),
        ACCEPTED("ACCEPTED"),
        DECLINED("DECLINED"),
        TIMEDOUT("TIMEDOUT"),
        CANCELLED("CANCELLED"),
        ERRORED("ERRORED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=TypesEnumDeserializer.class)
    public static enum TypesEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COBROWSE("COBROWSE"),
        SCREENSHARE("SCREENSHARE");

        private String value;

        private TypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypesEnum value : TypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypesEnumDeserializer
    extends StdDeserializer<TypesEnum> {
        public TypesEnumDeserializer() {
            super(TypesEnumDeserializer.class);
        }

        public TypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

