/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.PINConfiguration;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class VoicemailOrganizationPolicy
implements Serializable {
    private Boolean enabled = null;
    private Integer alertTimeoutSeconds = null;
    private PINConfiguration pinConfiguration = null;
    private String voicemailExtension = null;
    private Boolean pinRequired = null;
    private Boolean interactiveResponseRequired = null;
    private Boolean sendEmailNotifications = null;
    private Boolean includeEmailTranscriptions = null;
    private Boolean disableEmailPii = null;
    private Integer maximumRecordingTimeSeconds = null;
    private Date modifiedDate = null;

    public VoicemailOrganizationPolicy() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="Whether voicemail is enabled for this organization")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public VoicemailOrganizationPolicy alertTimeoutSeconds(Integer alertTimeoutSeconds) {
        this.alertTimeoutSeconds = alertTimeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The organization's default number of seconds to ring a user's phone before a call is transferred to voicemail")
    @JsonProperty(value="alertTimeoutSeconds")
    public Integer getAlertTimeoutSeconds() {
        return this.alertTimeoutSeconds;
    }

    public void setAlertTimeoutSeconds(Integer alertTimeoutSeconds) {
        this.alertTimeoutSeconds = alertTimeoutSeconds;
    }

    public VoicemailOrganizationPolicy pinConfiguration(PINConfiguration pinConfiguration) {
        this.pinConfiguration = pinConfiguration;
        return this;
    }

    @ApiModelProperty(example="null", value="The configuration for user PINs to access their voicemail from a phone")
    @JsonProperty(value="pinConfiguration")
    public PINConfiguration getPinConfiguration() {
        return this.pinConfiguration;
    }

    public void setPinConfiguration(PINConfiguration pinConfiguration) {
        this.pinConfiguration = pinConfiguration;
    }

    public VoicemailOrganizationPolicy voicemailExtension(String voicemailExtension) {
        this.voicemailExtension = voicemailExtension;
        return this;
    }

    @ApiModelProperty(example="null", value="The extension for voicemail retrieval.  The default value is *86.")
    @JsonProperty(value="voicemailExtension")
    public String getVoicemailExtension() {
        return this.voicemailExtension;
    }

    public void setVoicemailExtension(String voicemailExtension) {
        this.voicemailExtension = voicemailExtension;
    }

    public VoicemailOrganizationPolicy pinRequired(Boolean pinRequired) {
        this.pinRequired = pinRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="If this is true, a PIN is required when accessing a user's voicemail from a phone.")
    @JsonProperty(value="pinRequired")
    public Boolean getPinRequired() {
        return this.pinRequired;
    }

    public void setPinRequired(Boolean pinRequired) {
        this.pinRequired = pinRequired;
    }

    public VoicemailOrganizationPolicy interactiveResponseRequired(Boolean interactiveResponseRequired) {
        this.interactiveResponseRequired = interactiveResponseRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether user should be prompted with a confirmation prompt when connecting to a Group Ring call")
    @JsonProperty(value="interactiveResponseRequired")
    public Boolean getInteractiveResponseRequired() {
        return this.interactiveResponseRequired;
    }

    public void setInteractiveResponseRequired(Boolean interactiveResponseRequired) {
        this.interactiveResponseRequired = interactiveResponseRequired;
    }

    public VoicemailOrganizationPolicy sendEmailNotifications(Boolean sendEmailNotifications) {
        this.sendEmailNotifications = sendEmailNotifications;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether email notifications are sent for new voicemails in the organization. If false, new voicemail email notifications are not be sent for the organization overriding any user or group setting.")
    @JsonProperty(value="sendEmailNotifications")
    public Boolean getSendEmailNotifications() {
        return this.sendEmailNotifications;
    }

    public void setSendEmailNotifications(Boolean sendEmailNotifications) {
        this.sendEmailNotifications = sendEmailNotifications;
    }

    public VoicemailOrganizationPolicy includeEmailTranscriptions(Boolean includeEmailTranscriptions) {
        this.includeEmailTranscriptions = includeEmailTranscriptions;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to include the voicemail transcription in the notification email")
    @JsonProperty(value="includeEmailTranscriptions")
    public Boolean getIncludeEmailTranscriptions() {
        return this.includeEmailTranscriptions;
    }

    public void setIncludeEmailTranscriptions(Boolean includeEmailTranscriptions) {
        this.includeEmailTranscriptions = includeEmailTranscriptions;
    }

    public VoicemailOrganizationPolicy disableEmailPii(Boolean disableEmailPii) {
        this.disableEmailPii = disableEmailPii;
        return this;
    }

    @ApiModelProperty(example="null", value="Removes any PII from emails. This overrides any analogous group configuration value. This is always true if HIPAA is enabled or unknown for an organization.")
    @JsonProperty(value="disableEmailPii")
    public Boolean getDisableEmailPii() {
        return this.disableEmailPii;
    }

    public void setDisableEmailPii(Boolean disableEmailPii) {
        this.disableEmailPii = disableEmailPii;
    }

    public VoicemailOrganizationPolicy maximumRecordingTimeSeconds(Integer maximumRecordingTimeSeconds) {
        this.maximumRecordingTimeSeconds = maximumRecordingTimeSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Default value for the maximum length of time in seconds of a recorded voicemail")
    @JsonProperty(value="maximumRecordingTimeSeconds")
    public Integer getMaximumRecordingTimeSeconds() {
        return this.maximumRecordingTimeSeconds;
    }

    public void setMaximumRecordingTimeSeconds(Integer maximumRecordingTimeSeconds) {
        this.maximumRecordingTimeSeconds = maximumRecordingTimeSeconds;
    }

    @ApiModelProperty(example="null", value="The date the policy was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="modifiedDate")
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoicemailOrganizationPolicy voicemailOrganizationPolicy = (VoicemailOrganizationPolicy)o;
        return Objects.equals(this.enabled, voicemailOrganizationPolicy.enabled) && Objects.equals(this.alertTimeoutSeconds, voicemailOrganizationPolicy.alertTimeoutSeconds) && Objects.equals(this.pinConfiguration, voicemailOrganizationPolicy.pinConfiguration) && Objects.equals(this.voicemailExtension, voicemailOrganizationPolicy.voicemailExtension) && Objects.equals(this.pinRequired, voicemailOrganizationPolicy.pinRequired) && Objects.equals(this.interactiveResponseRequired, voicemailOrganizationPolicy.interactiveResponseRequired) && Objects.equals(this.sendEmailNotifications, voicemailOrganizationPolicy.sendEmailNotifications) && Objects.equals(this.includeEmailTranscriptions, voicemailOrganizationPolicy.includeEmailTranscriptions) && Objects.equals(this.disableEmailPii, voicemailOrganizationPolicy.disableEmailPii) && Objects.equals(this.maximumRecordingTimeSeconds, voicemailOrganizationPolicy.maximumRecordingTimeSeconds) && Objects.equals(this.modifiedDate, voicemailOrganizationPolicy.modifiedDate);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.alertTimeoutSeconds, this.pinConfiguration, this.voicemailExtension, this.pinRequired, this.interactiveResponseRequired, this.sendEmailNotifications, this.includeEmailTranscriptions, this.disableEmailPii, this.maximumRecordingTimeSeconds, this.modifiedDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VoicemailOrganizationPolicy {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    alertTimeoutSeconds: ").append(this.toIndentedString(this.alertTimeoutSeconds)).append("\n");
        sb.append("    pinConfiguration: ").append(this.toIndentedString(this.pinConfiguration)).append("\n");
        sb.append("    voicemailExtension: ").append(this.toIndentedString(this.voicemailExtension)).append("\n");
        sb.append("    pinRequired: ").append(this.toIndentedString(this.pinRequired)).append("\n");
        sb.append("    interactiveResponseRequired: ").append(this.toIndentedString(this.interactiveResponseRequired)).append("\n");
        sb.append("    sendEmailNotifications: ").append(this.toIndentedString(this.sendEmailNotifications)).append("\n");
        sb.append("    includeEmailTranscriptions: ").append(this.toIndentedString(this.includeEmailTranscriptions)).append("\n");
        sb.append("    disableEmailPii: ").append(this.toIndentedString(this.disableEmailPii)).append("\n");
        sb.append("    maximumRecordingTimeSeconds: ").append(this.toIndentedString(this.maximumRecordingTimeSeconds)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

