/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.CapacityPlanMetadata;
import com.mypurecloud.sdk.v2.model.ValueWrapperBuShortTermForecastReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class UpdateCapacityPlanRequest
implements Serializable {
    private String name = null;
    private String description = null;
    private LocalDate startBusinessUnitDate = null;
    private LocalDate endBusinessUnitDate = null;
    private ValueWrapperBuShortTermForecastReference forecast = null;
    private Double fullTimeEquivalentWeeklyHours = null;
    private Boolean useLatestPlanningGroupStaffingGroupAssociation = null;
    private CapacityPlanMetadata metadata = null;

    public UpdateCapacityPlanRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public UpdateCapacityPlanRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the capacity plan")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateCapacityPlanRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Description of the capacity plan")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateCapacityPlanRequest startBusinessUnitDate(LocalDate startBusinessUnitDate) {
        this.startBusinessUnitDate = startBusinessUnitDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="startBusinessUnitDate")
    public LocalDate getStartBusinessUnitDate() {
        return this.startBusinessUnitDate;
    }

    public void setStartBusinessUnitDate(LocalDate startBusinessUnitDate) {
        this.startBusinessUnitDate = startBusinessUnitDate;
    }

    public UpdateCapacityPlanRequest endBusinessUnitDate(LocalDate endBusinessUnitDate) {
        this.endBusinessUnitDate = endBusinessUnitDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The end date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="endBusinessUnitDate")
    public LocalDate getEndBusinessUnitDate() {
        return this.endBusinessUnitDate;
    }

    public void setEndBusinessUnitDate(LocalDate endBusinessUnitDate) {
        this.endBusinessUnitDate = endBusinessUnitDate;
    }

    public UpdateCapacityPlanRequest forecast(ValueWrapperBuShortTermForecastReference forecast) {
        this.forecast = forecast;
        return this;
    }

    @ApiModelProperty(example="null", value="The selected forecast for this capacity plan")
    @JsonProperty(value="forecast")
    public ValueWrapperBuShortTermForecastReference getForecast() {
        return this.forecast;
    }

    public void setForecast(ValueWrapperBuShortTermForecastReference forecast) {
        this.forecast = forecast;
    }

    public UpdateCapacityPlanRequest fullTimeEquivalentWeeklyHours(Double fullTimeEquivalentWeeklyHours) {
        this.fullTimeEquivalentWeeklyHours = fullTimeEquivalentWeeklyHours;
        return this;
    }

    @ApiModelProperty(example="null", value="The weekly hours used to calculate full time equivalent agents")
    @JsonProperty(value="fullTimeEquivalentWeeklyHours")
    public Double getFullTimeEquivalentWeeklyHours() {
        return this.fullTimeEquivalentWeeklyHours;
    }

    public void setFullTimeEquivalentWeeklyHours(Double fullTimeEquivalentWeeklyHours) {
        this.fullTimeEquivalentWeeklyHours = fullTimeEquivalentWeeklyHours;
    }

    public UpdateCapacityPlanRequest useLatestPlanningGroupStaffingGroupAssociation(Boolean useLatestPlanningGroupStaffingGroupAssociation) {
        this.useLatestPlanningGroupStaffingGroupAssociation = useLatestPlanningGroupStaffingGroupAssociation;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to use latest staffing group to planning group association")
    @JsonProperty(value="useLatestPlanningGroupStaffingGroupAssociation")
    public Boolean getUseLatestPlanningGroupStaffingGroupAssociation() {
        return this.useLatestPlanningGroupStaffingGroupAssociation;
    }

    public void setUseLatestPlanningGroupStaffingGroupAssociation(Boolean useLatestPlanningGroupStaffingGroupAssociation) {
        this.useLatestPlanningGroupStaffingGroupAssociation = useLatestPlanningGroupStaffingGroupAssociation;
    }

    public UpdateCapacityPlanRequest metadata(CapacityPlanMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The metadata of this capacity plan")
    @JsonProperty(value="metadata")
    public CapacityPlanMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(CapacityPlanMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateCapacityPlanRequest updateCapacityPlanRequest = (UpdateCapacityPlanRequest)o;
        return Objects.equals(this.name, updateCapacityPlanRequest.name) && Objects.equals(this.description, updateCapacityPlanRequest.description) && Objects.equals(this.startBusinessUnitDate, updateCapacityPlanRequest.startBusinessUnitDate) && Objects.equals(this.endBusinessUnitDate, updateCapacityPlanRequest.endBusinessUnitDate) && Objects.equals(this.forecast, updateCapacityPlanRequest.forecast) && Objects.equals(this.fullTimeEquivalentWeeklyHours, updateCapacityPlanRequest.fullTimeEquivalentWeeklyHours) && Objects.equals(this.useLatestPlanningGroupStaffingGroupAssociation, updateCapacityPlanRequest.useLatestPlanningGroupStaffingGroupAssociation) && Objects.equals(this.metadata, updateCapacityPlanRequest.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.startBusinessUnitDate, this.endBusinessUnitDate, this.forecast, this.fullTimeEquivalentWeeklyHours, this.useLatestPlanningGroupStaffingGroupAssociation, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateCapacityPlanRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    startBusinessUnitDate: ").append(this.toIndentedString(this.startBusinessUnitDate)).append("\n");
        sb.append("    endBusinessUnitDate: ").append(this.toIndentedString(this.endBusinessUnitDate)).append("\n");
        sb.append("    forecast: ").append(this.toIndentedString(this.forecast)).append("\n");
        sb.append("    fullTimeEquivalentWeeklyHours: ").append(this.toIndentedString(this.fullTimeEquivalentWeeklyHours)).append("\n");
        sb.append("    useLatestPlanningGroupStaffingGroupAssociation: ").append(this.toIndentedString(this.useLatestPlanningGroupStaffingGroupAssociation)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

