/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class Signature
implements Serializable {
    private Boolean enabled = null;
    private String cannedResponseId = null;
    private Boolean alwaysIncluded = null;
    private InclusionTypeEnum inclusionType = null;

    public Signature() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public Signature enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="A toggle to enable the signature on email send.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Signature cannedResponseId(String cannedResponseId) {
        this.cannedResponseId = cannedResponseId;
        return this;
    }

    @ApiModelProperty(example="null", value="The identifier referring to an email signature canned response.")
    @JsonProperty(value="cannedResponseId")
    public String getCannedResponseId() {
        return this.cannedResponseId;
    }

    public void setCannedResponseId(String cannedResponseId) {
        this.cannedResponseId = cannedResponseId;
    }

    public Signature alwaysIncluded(Boolean alwaysIncluded) {
        this.alwaysIncluded = alwaysIncluded;
        return this;
    }

    @ApiModelProperty(example="null", value="A toggle that defines if a signature is always included or only set on the first email in an email chain.")
    @JsonProperty(value="alwaysIncluded")
    public Boolean getAlwaysIncluded() {
        return this.alwaysIncluded;
    }

    public void setAlwaysIncluded(Boolean alwaysIncluded) {
        this.alwaysIncluded = alwaysIncluded;
    }

    public Signature inclusionType(InclusionTypeEnum inclusionType) {
        this.inclusionType = inclusionType;
        return this;
    }

    @ApiModelProperty(example="null", value="The configuration to indicate when the signature of a conversation has to be included")
    @JsonProperty(value="inclusionType")
    public InclusionTypeEnum getInclusionType() {
        return this.inclusionType;
    }

    public void setInclusionType(InclusionTypeEnum inclusionType) {
        this.inclusionType = inclusionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return Objects.equals(this.enabled, signature.enabled) && Objects.equals(this.cannedResponseId, signature.cannedResponseId) && Objects.equals(this.alwaysIncluded, signature.alwaysIncluded) && Objects.equals((Object)this.inclusionType, (Object)signature.inclusionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.cannedResponseId, this.alwaysIncluded, this.inclusionType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Signature {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    cannedResponseId: ").append(this.toIndentedString(this.cannedResponseId)).append("\n");
        sb.append("    alwaysIncluded: ").append(this.toIndentedString(this.alwaysIncluded)).append("\n");
        sb.append("    inclusionType: ").append(this.toIndentedString((Object)this.inclusionType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=InclusionTypeEnumDeserializer.class)
    public static enum InclusionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DRAFT("Draft"),
        SEND("Send"),
        SENDONCE("SendOnce");

        private String value;

        private InclusionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InclusionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InclusionTypeEnum value : InclusionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InclusionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class InclusionTypeEnumDeserializer
    extends StdDeserializer<InclusionTypeEnum> {
        public InclusionTypeEnumDeserializer() {
            super(InclusionTypeEnumDeserializer.class);
        }

        public InclusionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return InclusionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

