/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class PhoneNumber
implements Serializable {
    private String display = null;
    private Long extension = null;
    private Boolean acceptsSMS = null;
    private String normalizationCountryCode = null;
    private String userInput = null;
    private String e164 = null;
    private String countryCode = null;

    public PhoneNumber() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public PhoneNumber display(String display) {
        this.display = display;
        return this;
    }

    @ApiModelProperty(example="null", value="The displayed form of the phone number string. Users should input the phone number in this field, but it will be altered by the API on write. If the phone number can be read as E164, the value will be replaced with international formatted-version of the number. If the number cannot be read as E164, the value will be preserved as-is. In both cases, the provided input string will be copied to the userInput field.")
    @JsonProperty(value="display")
    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public PhoneNumber extension(Long extension) {
        this.extension = extension;
        return this;
    }

    @ApiModelProperty(example="null", value="An optional extension for the provided phone number.")
    @JsonProperty(value="extension")
    public Long getExtension() {
        return this.extension;
    }

    public void setExtension(Long extension) {
        this.extension = extension;
    }

    public PhoneNumber acceptsSMS(Boolean acceptsSMS) {
        this.acceptsSMS = acceptsSMS;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this phone number can accept SMS messages.")
    @JsonProperty(value="acceptsSMS")
    public Boolean getAcceptsSMS() {
        return this.acceptsSMS;
    }

    public void setAcceptsSMS(Boolean acceptsSMS) {
        this.acceptsSMS = acceptsSMS;
    }

    public PhoneNumber normalizationCountryCode(String normalizationCountryCode) {
        this.normalizationCountryCode = normalizationCountryCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The country code that will be used for E164 conversion of a provided phone number. If the country code is omitted from the provided phone number, the country code provided in this field will be used during the E164 conversion attempt. If this field is left empty, the default country code for any provided phone number that does not explicitly include a country code is assumed to be +1 (North America).")
    @JsonProperty(value="normalizationCountryCode")
    public String getNormalizationCountryCode() {
        return this.normalizationCountryCode;
    }

    public void setNormalizationCountryCode(String normalizationCountryCode) {
        this.normalizationCountryCode = normalizationCountryCode;
    }

    public PhoneNumber userInput(String userInput) {
        this.userInput = userInput;
        return this;
    }

    @ApiModelProperty(example="null", value="The user-inputted phone number string that was provided to the display field on write. This field is not user-writeable and will always be set by the system.")
    @JsonProperty(value="userInput")
    public String getUserInput() {
        return this.userInput;
    }

    public void setUserInput(String userInput) {
        this.userInput = userInput;
    }

    public PhoneNumber e164(String e164) {
        this.e164 = e164;
        return this;
    }

    @ApiModelProperty(example="null", value="The E164-formatted form of the provided phone number. This field is not user-writeable and will only be set when the provided phone number could be read as E164.")
    @JsonProperty(value="e164")
    public String getE164() {
        return this.e164;
    }

    public void setE164(String e164) {
        this.e164 = e164;
    }

    public PhoneNumber countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The detected country code from the provided phone number. This field is not user-writeable and will only be set when the provided phone number could be read as E164.")
    @JsonProperty(value="countryCode")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber phoneNumber = (PhoneNumber)o;
        return Objects.equals(this.display, phoneNumber.display) && Objects.equals(this.extension, phoneNumber.extension) && Objects.equals(this.acceptsSMS, phoneNumber.acceptsSMS) && Objects.equals(this.normalizationCountryCode, phoneNumber.normalizationCountryCode) && Objects.equals(this.userInput, phoneNumber.userInput) && Objects.equals(this.e164, phoneNumber.e164) && Objects.equals(this.countryCode, phoneNumber.countryCode);
    }

    public int hashCode() {
        return Objects.hash(this.display, this.extension, this.acceptsSMS, this.normalizationCountryCode, this.userInput, this.e164, this.countryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhoneNumber {\n");
        sb.append("    display: ").append(this.toIndentedString(this.display)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    acceptsSMS: ").append(this.toIndentedString(this.acceptsSMS)).append("\n");
        sb.append("    normalizationCountryCode: ").append(this.toIndentedString(this.normalizationCountryCode)).append("\n");
        sb.append("    userInput: ").append(this.toIndentedString(this.userInput)).append("\n");
        sb.append("    e164: ").append(this.toIndentedString(this.e164)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

