/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class PaymentResponse
implements Serializable {
    private String originatingMessageId = null;
    private PaymentStatusEnum paymentStatus = null;
    private String failureReason = null;

    public PaymentResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public PaymentResponse originatingMessageId(String originatingMessageId) {
        this.originatingMessageId = originatingMessageId;
        return this;
    }

    @ApiModelProperty(example="null", value="Reference to the ID of the original payment request message this response is for.")
    @JsonProperty(value="originatingMessageId")
    public String getOriginatingMessageId() {
        return this.originatingMessageId;
    }

    public void setOriginatingMessageId(String originatingMessageId) {
        this.originatingMessageId = originatingMessageId;
    }

    public PaymentResponse paymentStatus(PaymentStatusEnum paymentStatus) {
        this.paymentStatus = paymentStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the payment transaction.")
    @JsonProperty(value="paymentStatus")
    public PaymentStatusEnum getPaymentStatus() {
        return this.paymentStatus;
    }

    public void setPaymentStatus(PaymentStatusEnum paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public PaymentResponse failureReason(String failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason the payment request failed.")
    @JsonProperty(value="failureReason")
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentResponse paymentResponse = (PaymentResponse)o;
        return Objects.equals(this.originatingMessageId, paymentResponse.originatingMessageId) && Objects.equals((Object)this.paymentStatus, (Object)paymentResponse.paymentStatus) && Objects.equals(this.failureReason, paymentResponse.failureReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.originatingMessageId, this.paymentStatus, this.failureReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentResponse {\n");
        sb.append("    originatingMessageId: ").append(this.toIndentedString(this.originatingMessageId)).append("\n");
        sb.append("    paymentStatus: ").append(this.toIndentedString((Object)this.paymentStatus)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PaymentStatusEnumDeserializer.class)
    public static enum PaymentStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COMPLETED("Completed"),
        FAILED("Failed");

        private String value;

        private PaymentStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PaymentStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PaymentStatusEnum value : PaymentStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PaymentStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PaymentStatusEnumDeserializer
    extends StdDeserializer<PaymentStatusEnum> {
        public PaymentStatusEnumDeserializer() {
            super(PaymentStatusEnumDeserializer.class);
        }

        public PaymentStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PaymentStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

