/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AnalyticsScoredAgent;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ObservationValue
implements Serializable {
    private Date observationDate = null;
    private String conversationId = null;
    private String sessionId = null;
    private List<String> requestedRoutingSkillIds = null;
    private String requestedLanguageId = null;
    private Long routingPriority = null;
    private String participantName = null;
    private String userId = null;
    private DirectionEnum direction = null;
    private String convertedFrom = null;
    private String convertedTo = null;
    private String addressFrom = null;
    private String addressTo = null;
    private String ani = null;
    private String dnis = null;
    private String teamId = null;
    private List<RequestedRoutingsEnum> requestedRoutings = null;
    private UsedRoutingEnum usedRouting = null;
    private List<AnalyticsScoredAgent> scoredAgents = null;

    public ObservationValue() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.requestedRoutingSkillIds = new ArrayList<String>();
            this.requestedRoutings = new ArrayList<RequestedRoutingsEnum>();
            this.scoredAgents = new ArrayList<AnalyticsScoredAgent>();
        }
    }

    public ObservationValue observationDate(Date observationDate) {
        this.observationDate = observationDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The time at which the observation occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="observationDate")
    public Date getObservationDate() {
        return this.observationDate;
    }

    public void setObservationDate(Date observationDate) {
        this.observationDate = observationDate;
    }

    public ObservationValue conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public ObservationValue sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier of this session")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public ObservationValue requestedRoutingSkillIds(List<String> requestedRoutingSkillIds) {
        this.requestedRoutingSkillIds = requestedRoutingSkillIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for a skill requested for an interaction")
    @JsonProperty(value="requestedRoutingSkillIds")
    public List<String> getRequestedRoutingSkillIds() {
        return this.requestedRoutingSkillIds;
    }

    public void setRequestedRoutingSkillIds(List<String> requestedRoutingSkillIds) {
        this.requestedRoutingSkillIds = requestedRoutingSkillIds;
    }

    public ObservationValue requestedLanguageId(String requestedLanguageId) {
        this.requestedLanguageId = requestedLanguageId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the language requested for an interaction")
    @JsonProperty(value="requestedLanguageId")
    public String getRequestedLanguageId() {
        return this.requestedLanguageId;
    }

    public void setRequestedLanguageId(String requestedLanguageId) {
        this.requestedLanguageId = requestedLanguageId;
    }

    public ObservationValue routingPriority(Long routingPriority) {
        this.routingPriority = routingPriority;
        return this;
    }

    @ApiModelProperty(example="null", value="Routing priority for the current interaction")
    @JsonProperty(value="routingPriority")
    public Long getRoutingPriority() {
        return this.routingPriority;
    }

    public void setRoutingPriority(Long routingPriority) {
        this.routingPriority = routingPriority;
    }

    public ObservationValue participantName(String participantName) {
        this.participantName = participantName;
        return this;
    }

    @ApiModelProperty(example="null", value="A human readable name identifying the participant")
    @JsonProperty(value="participantName")
    public String getParticipantName() {
        return this.participantName;
    }

    public void setParticipantName(String participantName) {
        this.participantName = participantName;
    }

    public ObservationValue userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the user")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ObservationValue direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the communication")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public ObservationValue convertedFrom(String convertedFrom) {
        this.convertedFrom = convertedFrom;
        return this;
    }

    @ApiModelProperty(example="null", value="Session media type that was converted from in case of a media type conversion")
    @JsonProperty(value="convertedFrom")
    public String getConvertedFrom() {
        return this.convertedFrom;
    }

    public void setConvertedFrom(String convertedFrom) {
        this.convertedFrom = convertedFrom;
    }

    public ObservationValue convertedTo(String convertedTo) {
        this.convertedTo = convertedTo;
        return this;
    }

    @ApiModelProperty(example="null", value="Session media type that was converted to in case of a media type conversion")
    @JsonProperty(value="convertedTo")
    public String getConvertedTo() {
        return this.convertedTo;
    }

    public void setConvertedTo(String convertedTo) {
        this.convertedTo = convertedTo;
    }

    public ObservationValue addressFrom(String addressFrom) {
        this.addressFrom = addressFrom;
        return this;
    }

    @ApiModelProperty(example="null", value="The address that initiated an action")
    @JsonProperty(value="addressFrom")
    public String getAddressFrom() {
        return this.addressFrom;
    }

    public void setAddressFrom(String addressFrom) {
        this.addressFrom = addressFrom;
    }

    public ObservationValue addressTo(String addressTo) {
        this.addressTo = addressTo;
        return this;
    }

    @ApiModelProperty(example="null", value="The address receiving an action")
    @JsonProperty(value="addressTo")
    public String getAddressTo() {
        return this.addressTo;
    }

    public void setAddressTo(String addressTo) {
        this.addressTo = addressTo;
    }

    public ObservationValue ani(String ani) {
        this.ani = ani;
        return this;
    }

    @ApiModelProperty(example="null", value="Automatic Number Identification (caller's number)")
    @JsonProperty(value="ani")
    public String getAni() {
        return this.ani;
    }

    public void setAni(String ani) {
        this.ani = ani;
    }

    public ObservationValue dnis(String dnis) {
        this.dnis = dnis;
        return this;
    }

    @ApiModelProperty(example="null", value="Dialed number identification service (number dialed by the calling party)")
    @JsonProperty(value="dnis")
    public String getDnis() {
        return this.dnis;
    }

    public void setDnis(String dnis) {
        this.dnis = dnis;
    }

    public ObservationValue teamId(String teamId) {
        this.teamId = teamId;
        return this;
    }

    @ApiModelProperty(example="null", value="The team id the user is a member of")
    @JsonProperty(value="teamId")
    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public ObservationValue requestedRoutings(List<RequestedRoutingsEnum> requestedRoutings) {
        this.requestedRoutings = requestedRoutings;
        return this;
    }

    @ApiModelProperty(example="null", value="All routing types for requested/attempted routing methods")
    @JsonProperty(value="requestedRoutings")
    public List<RequestedRoutingsEnum> getRequestedRoutings() {
        return this.requestedRoutings;
    }

    public void setRequestedRoutings(List<RequestedRoutingsEnum> requestedRoutings) {
        this.requestedRoutings = requestedRoutings;
    }

    public ObservationValue usedRouting(UsedRoutingEnum usedRouting) {
        this.usedRouting = usedRouting;
        return this;
    }

    @ApiModelProperty(example="null", value="Complete routing method")
    @JsonProperty(value="usedRouting")
    public UsedRoutingEnum getUsedRouting() {
        return this.usedRouting;
    }

    public void setUsedRouting(UsedRoutingEnum usedRouting) {
        this.usedRouting = usedRouting;
    }

    public ObservationValue scoredAgents(List<AnalyticsScoredAgent> scoredAgents) {
        this.scoredAgents = scoredAgents;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="scoredAgents")
    public List<AnalyticsScoredAgent> getScoredAgents() {
        return this.scoredAgents;
    }

    public void setScoredAgents(List<AnalyticsScoredAgent> scoredAgents) {
        this.scoredAgents = scoredAgents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObservationValue observationValue = (ObservationValue)o;
        return Objects.equals(this.observationDate, observationValue.observationDate) && Objects.equals(this.conversationId, observationValue.conversationId) && Objects.equals(this.sessionId, observationValue.sessionId) && Objects.equals(this.requestedRoutingSkillIds, observationValue.requestedRoutingSkillIds) && Objects.equals(this.requestedLanguageId, observationValue.requestedLanguageId) && Objects.equals(this.routingPriority, observationValue.routingPriority) && Objects.equals(this.participantName, observationValue.participantName) && Objects.equals(this.userId, observationValue.userId) && Objects.equals((Object)this.direction, (Object)observationValue.direction) && Objects.equals(this.convertedFrom, observationValue.convertedFrom) && Objects.equals(this.convertedTo, observationValue.convertedTo) && Objects.equals(this.addressFrom, observationValue.addressFrom) && Objects.equals(this.addressTo, observationValue.addressTo) && Objects.equals(this.ani, observationValue.ani) && Objects.equals(this.dnis, observationValue.dnis) && Objects.equals(this.teamId, observationValue.teamId) && Objects.equals(this.requestedRoutings, observationValue.requestedRoutings) && Objects.equals((Object)this.usedRouting, (Object)observationValue.usedRouting) && Objects.equals(this.scoredAgents, observationValue.scoredAgents);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.observationDate, this.conversationId, this.sessionId, this.requestedRoutingSkillIds, this.requestedLanguageId, this.routingPriority, this.participantName, this.userId, this.direction, this.convertedFrom, this.convertedTo, this.addressFrom, this.addressTo, this.ani, this.dnis, this.teamId, this.requestedRoutings, this.usedRouting, this.scoredAgents});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObservationValue {\n");
        sb.append("    observationDate: ").append(this.toIndentedString(this.observationDate)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    requestedRoutingSkillIds: ").append(this.toIndentedString(this.requestedRoutingSkillIds)).append("\n");
        sb.append("    requestedLanguageId: ").append(this.toIndentedString(this.requestedLanguageId)).append("\n");
        sb.append("    routingPriority: ").append(this.toIndentedString(this.routingPriority)).append("\n");
        sb.append("    participantName: ").append(this.toIndentedString(this.participantName)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    convertedFrom: ").append(this.toIndentedString(this.convertedFrom)).append("\n");
        sb.append("    convertedTo: ").append(this.toIndentedString(this.convertedTo)).append("\n");
        sb.append("    addressFrom: ").append(this.toIndentedString(this.addressFrom)).append("\n");
        sb.append("    addressTo: ").append(this.toIndentedString(this.addressTo)).append("\n");
        sb.append("    ani: ").append(this.toIndentedString(this.ani)).append("\n");
        sb.append("    dnis: ").append(this.toIndentedString(this.dnis)).append("\n");
        sb.append("    teamId: ").append(this.toIndentedString(this.teamId)).append("\n");
        sb.append("    requestedRoutings: ").append(this.toIndentedString(this.requestedRoutings)).append("\n");
        sb.append("    usedRouting: ").append(this.toIndentedString((Object)this.usedRouting)).append("\n");
        sb.append("    scoredAgents: ").append(this.toIndentedString(this.scoredAgents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=UsedRoutingEnumDeserializer.class)
    public static enum UsedRoutingEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BULLSEYE("Bullseye"),
        CONDITIONAL("Conditional"),
        DIRECT("Direct"),
        LAST("Last"),
        MANUAL("Manual"),
        PREDICTIVE("Predictive"),
        PREFERRED("Preferred"),
        STANDARD("Standard"),
        VIP("Vip");

        private String value;

        private UsedRoutingEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UsedRoutingEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UsedRoutingEnum value : UsedRoutingEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UsedRoutingEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UsedRoutingEnumDeserializer
    extends StdDeserializer<UsedRoutingEnum> {
        public UsedRoutingEnumDeserializer() {
            super(UsedRoutingEnumDeserializer.class);
        }

        public UsedRoutingEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UsedRoutingEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=RequestedRoutingsEnumDeserializer.class)
    public static enum RequestedRoutingsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BULLSEYE("Bullseye"),
        CONDITIONAL("Conditional"),
        DIRECT("Direct"),
        LAST("Last"),
        MANUAL("Manual"),
        PREDICTIVE("Predictive"),
        PREFERRED("Preferred"),
        STANDARD("Standard"),
        VIP("Vip");

        private String value;

        private RequestedRoutingsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RequestedRoutingsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RequestedRoutingsEnum value : RequestedRoutingsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RequestedRoutingsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RequestedRoutingsEnumDeserializer
    extends StdDeserializer<RequestedRoutingsEnum> {
        public RequestedRoutingsEnumDeserializer() {
            super(RequestedRoutingsEnumDeserializer.class);
        }

        public RequestedRoutingsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RequestedRoutingsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

