/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ApprovalNamespace;
import com.mypurecloud.sdk.v2.model.StatusChange;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class LimitChangeRequestDetails
implements Serializable {
    private String id = null;
    private String key = null;
    private NamespaceEnum namespace = null;
    private Double requestedValue = null;
    private String description = null;
    private String supportCaseUrl = null;
    private StatusEnum status = null;
    private Double currentValue = null;
    private Date dateCreated = null;
    private List<StatusChange> statusHistory = null;
    private Date dateCompleted = null;
    private RejectReasonEnum rejectReason = null;
    private List<ApprovalNamespace> approvalNamespaces = null;
    private String selfUri = null;

    public LimitChangeRequestDetails() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.statusHistory = new ArrayList<StatusChange>();
            this.approvalNamespaces = new ArrayList<ApprovalNamespace>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public LimitChangeRequestDetails key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Limit key to be overridden (see https://developer.mypurecloud.com/api/rest/v2/organization/limits.html#available_limits)")
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public LimitChangeRequestDetails namespace(NamespaceEnum namespace) {
        this.namespace = namespace;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Namespace the key belongs to (see https://developer.mypurecloud.com/api/rest/v2/organization/limits.html#available_limits)")
    @JsonProperty(value="namespace")
    public NamespaceEnum getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceEnum namespace) {
        this.namespace = namespace;
    }

    public LimitChangeRequestDetails requestedValue(Double requestedValue) {
        this.requestedValue = requestedValue;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Requested limit value for a given key")
    @JsonProperty(value="requestedValue")
    public Double getRequestedValue() {
        return this.requestedValue;
    }

    public void setRequestedValue(Double requestedValue) {
        this.requestedValue = requestedValue;
    }

    public LimitChangeRequestDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Description of the need for the limit change request")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LimitChangeRequestDetails supportCaseUrl(String supportCaseUrl) {
        this.supportCaseUrl = supportCaseUrl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The support case url created by Care")
    @JsonProperty(value="supportCaseUrl")
    public String getSupportCaseUrl() {
        return this.supportCaseUrl;
    }

    public void setSupportCaseUrl(String supportCaseUrl) {
        this.supportCaseUrl = supportCaseUrl;
    }

    @ApiModelProperty(example="null", value="Current status of the limit change request")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Current limit value for a given key")
    @JsonProperty(value="currentValue")
    public Double getCurrentValue() {
        return this.currentValue;
    }

    @ApiModelProperty(example="null", value="The date of the limit change request creation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="List of statuses that a limit change request has gone through")
    @JsonProperty(value="statusHistory")
    public List<StatusChange> getStatusHistory() {
        return this.statusHistory;
    }

    @ApiModelProperty(example="null", value="The date of the limit change request completion (ChangeImplemented, Rejected, or RollbackImplemented. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCompleted")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    @ApiModelProperty(example="null", value="The reason for rejecting the limit override request")
    @JsonProperty(value="rejectReason")
    public RejectReasonEnum getRejectReason() {
        return this.rejectReason;
    }

    @ApiModelProperty(example="null", value="The approval breakdown for this override request.")
    @JsonProperty(value="approvalNamespaces")
    public List<ApprovalNamespace> getApprovalNamespaces() {
        return this.approvalNamespaces;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitChangeRequestDetails limitChangeRequestDetails = (LimitChangeRequestDetails)o;
        return Objects.equals(this.id, limitChangeRequestDetails.id) && Objects.equals(this.key, limitChangeRequestDetails.key) && Objects.equals((Object)this.namespace, (Object)limitChangeRequestDetails.namespace) && Objects.equals(this.requestedValue, limitChangeRequestDetails.requestedValue) && Objects.equals(this.description, limitChangeRequestDetails.description) && Objects.equals(this.supportCaseUrl, limitChangeRequestDetails.supportCaseUrl) && Objects.equals((Object)this.status, (Object)limitChangeRequestDetails.status) && Objects.equals(this.currentValue, limitChangeRequestDetails.currentValue) && Objects.equals(this.dateCreated, limitChangeRequestDetails.dateCreated) && Objects.equals(this.statusHistory, limitChangeRequestDetails.statusHistory) && Objects.equals(this.dateCompleted, limitChangeRequestDetails.dateCompleted) && Objects.equals((Object)this.rejectReason, (Object)limitChangeRequestDetails.rejectReason) && Objects.equals(this.approvalNamespaces, limitChangeRequestDetails.approvalNamespaces) && Objects.equals(this.selfUri, limitChangeRequestDetails.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.key, this.namespace, this.requestedValue, this.description, this.supportCaseUrl, this.status, this.currentValue, this.dateCreated, this.statusHistory, this.dateCompleted, this.rejectReason, this.approvalNamespaces, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LimitChangeRequestDetails {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString((Object)this.namespace)).append("\n");
        sb.append("    requestedValue: ").append(this.toIndentedString(this.requestedValue)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    supportCaseUrl: ").append(this.toIndentedString(this.supportCaseUrl)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    currentValue: ").append(this.toIndentedString(this.currentValue)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    statusHistory: ").append(this.toIndentedString(this.statusHistory)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    rejectReason: ").append(this.toIndentedString((Object)this.rejectReason)).append("\n");
        sb.append("    approvalNamespaces: ").append(this.toIndentedString(this.approvalNamespaces)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=NamespaceEnumDeserializer.class)
    public static enum NamespaceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WORKFORCE_MANAGEMENT("workforce.management"),
        AGENT_ASSISTANT("agent.assistant"),
        ANALYTICS_AGENTS("analytics.agents"),
        ANALYTICS_ALERTING("analytics.alerting"),
        ANALYTICS_DATA_EXTRACTION("analytics.data.extraction"),
        ANALYTICS("analytics"),
        ANALYTICS_REALTIME("analytics.realtime"),
        ANALYTICS_REPORTING_SETTINGS("analytics.reporting.settings"),
        ARCHITECT("architect"),
        AUDIOHOOK("audiohook"),
        AUDIOHOOK_MONITOR("audiohook.monitor"),
        AUDIT("audit"),
        AUTH_API("auth.api"),
        AUTHORIZATION("authorization"),
        AUTOMATION_TESTING("automation.testing"),
        BOTS("bots"),
        BOTS_VOICE("bots.voice"),
        BUSINESS_RULES("business.rules"),
        CALLBACK("callback"),
        COBROWSE("cobrowse"),
        CONTENT_MANAGEMENT("content.management"),
        CONVERSATION("conversation"),
        DATAACTIONS("dataactions"),
        DATATABLES("datatables"),
        DIRECTORY("directory"),
        DSAR("dsar"),
        EMAIL("email"),
        EMPLOYEE_ENGAGEMENT("employee.engagement"),
        EVENT_ORCHESTRATION("event.orchestration"),
        EXTERNAL_CONTACTS("external.contacts"),
        EXTERNAL_EVENTS_DATA_INGESTION("external.events.data.ingestion"),
        GAMIFICATION("gamification"),
        GCV("gcv"),
        GDPR("gdpr"),
        GROUPS("groups"),
        GUIDES("guides"),
        HISTORICAL_ADHERENCE("historical.adherence"),
        INFRASTRUCTUREASCODE("infrastructureascode"),
        INTEGRATIONS("integrations"),
        INTENT_MINER("intent.miner"),
        INTERNAL_MESSAGING("internal.messaging"),
        JOURNEY("journey"),
        KNOWLEDGE("knowledge"),
        LANGUAGE_UNDERSTANDING("language.understanding"),
        LEARNING("learning"),
        LIMIT_REGISTRY("limit.registry"),
        MARKETPLACE("marketplace"),
        MEDIA_COMMUNICATIONS("media.communications"),
        MESSAGING("messaging"),
        MICRO_FRONTEND("micro.frontend"),
        NOTIFICATIONS("notifications"),
        ONBOARDING("onboarding"),
        OUTBOUND("outbound"),
        PLATFORM_API("platform.api"),
        PREDICTIVE_ROUTING("predictive.routing"),
        PRESENCE("presence"),
        QUALITY("quality"),
        RECORDING("recording"),
        RESPONSE_MANAGEMENT("response.management"),
        ROUTING("routing"),
        SCIM("scim"),
        SCREEN_MONITORING("screen.monitoring"),
        SEARCH("search"),
        SECONDARY_AUTOMATION_TESTING("secondary.automation.testing"),
        SKILLS("skills"),
        SOCIAL_MEDIA("social.media"),
        SPEECH_AND_TEXT_ANALYTICS("speech.and.text.analytics"),
        SPEECH_INTEGRATION("speech.integration"),
        SUPPORTABILITY("supportability"),
        TASK_MANAGEMENT("task.management"),
        TELEPHONY_CONFIGURATION("telephony.configuration"),
        USAGE("usage"),
        USERS("users"),
        USERS_RULES("users.rules"),
        VOICE_TRANSCRIPTION("voice.transcription"),
        WEB_DEPLOYMENTS("web.deployments"),
        WEB_MESSAGING("web.messaging"),
        WEBCHAT("webchat"),
        WEBHOOKS("webhooks"),
        WORKFORCE_MANAGEMENT_AGENT_AVAILABILITY("workforce.management.agent.availability"),
        WORKFORCE_MANAGEMENT_FORECAST("workforce.management.forecast"),
        SYSTEM("system");

        private String value;

        private NamespaceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NamespaceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NamespaceEnum value : NamespaceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NamespaceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        APPROVED("Approved"),
        REJECTED("Rejected"),
        ROLLBACK("Rollback"),
        PENDING("Pending"),
        OPEN("Open"),
        SECONDARYAPPROVALNAMESPACESADDED("SecondaryApprovalNamespacesAdded"),
        REVIEWERAPPROVED("ReviewerApproved"),
        REVIEWERREJECTED("ReviewerRejected"),
        REVIEWERROLLBACK("ReviewerRollback"),
        IMPLEMENTINGCHANGE("ImplementingChange"),
        CHANGEIMPLEMENTED("ChangeImplemented"),
        IMPLEMENTINGROLLBACK("ImplementingRollback"),
        ROLLBACKIMPLEMENTED("RollbackImplemented");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=RejectReasonEnumDeserializer.class)
    public static enum RejectReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALTERNATIVEEXISTS("AlternativeExists"),
        INCREASENOTREQUIRED("IncreaseNotRequired"),
        PLATFORMMISUSE("PlatformMisuse"),
        PLATFORMSTABILITY("PlatformStability"),
        OTHERREASON("OtherReason");

        private String value;

        private RejectReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RejectReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RejectReasonEnum value : RejectReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RejectReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RejectReasonEnumDeserializer
    extends StdDeserializer<RejectReasonEnum> {
        public RejectReasonEnumDeserializer() {
            super(RejectReasonEnumDeserializer.class);
        }

        public RejectReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RejectReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class NamespaceEnumDeserializer
    extends StdDeserializer<NamespaceEnum> {
        public NamespaceEnumDeserializer() {
            super(NamespaceEnumDeserializer.class);
        }

        public NamespaceEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NamespaceEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

