/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class KnowledgeConversationContextResponse
implements Serializable {
    private AddressableEntityRef conversation = null;
    private AddressableEntityRef queue = null;
    private AddressableEntityRef externalContact = null;
    private MediaTypeEnum mediaType = null;

    public KnowledgeConversationContextResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public KnowledgeConversationContextResponse conversation(AddressableEntityRef conversation) {
        this.conversation = conversation;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The conversation.")
    @JsonProperty(value="conversation")
    public AddressableEntityRef getConversation() {
        return this.conversation;
    }

    public void setConversation(AddressableEntityRef conversation) {
        this.conversation = conversation;
    }

    public KnowledgeConversationContextResponse queue(AddressableEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue used to assign the interaction to the user.")
    @JsonProperty(value="queue")
    public AddressableEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(AddressableEntityRef queue) {
        this.queue = queue;
    }

    public KnowledgeConversationContextResponse externalContact(AddressableEntityRef externalContact) {
        this.externalContact = externalContact;
        return this;
    }

    @ApiModelProperty(example="null", value="The end-user participant of the conversation.")
    @JsonProperty(value="externalContact")
    public AddressableEntityRef getExternalContact() {
        return this.externalContact;
    }

    public void setExternalContact(AddressableEntityRef externalContact) {
        this.externalContact = externalContact;
    }

    public KnowledgeConversationContextResponse mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="The media type of the conversation.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeConversationContextResponse knowledgeConversationContextResponse = (KnowledgeConversationContextResponse)o;
        return Objects.equals(this.conversation, knowledgeConversationContextResponse.conversation) && Objects.equals(this.queue, knowledgeConversationContextResponse.queue) && Objects.equals(this.externalContact, knowledgeConversationContextResponse.externalContact) && Objects.equals((Object)this.mediaType, (Object)knowledgeConversationContextResponse.mediaType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversation, this.queue, this.externalContact, this.mediaType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeConversationContextResponse {\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        CALLBACK("Callback"),
        CHAT("Chat"),
        COBROWSE("Cobrowse"),
        EMAIL("Email"),
        MESSAGE("Message"),
        SCREENSHARE("Screenshare"),
        VIDEO("Video"),
        VOICE("Voice");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

