/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.KnowledgeBase;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class KnowledgeCategory
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private KnowledgeBase knowledgeBase = null;
    private LanguageCodeEnum languageCode = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;

    public KnowledgeCategory() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeCategory name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Category name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public KnowledgeCategory description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Category description")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="null", value="Knowledge base which category does belong to")
    @JsonProperty(value="knowledgeBase")
    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    @ApiModelProperty(example="null", value="Actual language of the category")
    @JsonProperty(value="languageCode")
    public LanguageCodeEnum getLanguageCode() {
        return this.languageCode;
    }

    @ApiModelProperty(example="null", value="Category creation date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Category last modification date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeCategory knowledgeCategory = (KnowledgeCategory)o;
        return Objects.equals(this.id, knowledgeCategory.id) && Objects.equals(this.name, knowledgeCategory.name) && Objects.equals(this.description, knowledgeCategory.description) && Objects.equals(this.knowledgeBase, knowledgeCategory.knowledgeBase) && Objects.equals((Object)this.languageCode, (Object)knowledgeCategory.languageCode) && Objects.equals(this.dateCreated, knowledgeCategory.dateCreated) && Objects.equals(this.dateModified, knowledgeCategory.dateModified) && Objects.equals(this.selfUri, knowledgeCategory.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.knowledgeBase, this.languageCode, this.dateCreated, this.dateModified, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeCategory {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    knowledgeBase: ").append(this.toIndentedString(this.knowledgeBase)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString((Object)this.languageCode)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LanguageCodeEnumDeserializer.class)
    public static enum LanguageCodeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EN_US("en-US"),
        EN_UK("en-UK"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_HK("en-HK"),
        EN_IN("en-IN"),
        EN_IE("en-IE"),
        EN_NZ("en-NZ"),
        EN_PH("en-PH"),
        EN_SG("en-SG"),
        EN_ZA("en-ZA"),
        DE_DE("de-DE"),
        DE_AT("de-AT"),
        DE_CH("de-CH"),
        ES_AR("es-AR"),
        ES_CO("es-CO"),
        ES_MX("es-MX"),
        ES_US("es-US"),
        ES_ES("es-ES"),
        FR_FR("fr-FR"),
        FR_BE("fr-BE"),
        FR_CA("fr-CA"),
        FR_CH("fr-CH"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        NL_NL("nl-NL"),
        NL_BE("nl-BE"),
        IT_IT("it-IT"),
        CA_ES("ca-ES"),
        TR_TR("tr-TR"),
        SV_SE("sv-SE"),
        FI_FI("fi-FI"),
        NB_NO("nb-NO"),
        DA_DK("da-DK"),
        JA_JP("ja-JP"),
        AR_AE("ar-AE"),
        ZH_CN("zh-CN"),
        ZH_TW("zh-TW"),
        ZH_HK("zh-HK"),
        KO_KR("ko-KR"),
        PL_PL("pl-PL"),
        HI_IN("hi-IN"),
        TH_TH("th-TH"),
        HU_HU("hu-HU"),
        VI_VN("vi-VN"),
        UK_UA("uk-UA"),
        CS_CZ("cs-CZ");

        private String value;

        private LanguageCodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LanguageCodeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LanguageCodeEnum value : LanguageCodeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LanguageCodeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class LanguageCodeEnumDeserializer
    extends StdDeserializer<LanguageCodeEnum> {
        public LanguageCodeEnumDeserializer() {
            super(LanguageCodeEnumDeserializer.class);
        }

        public LanguageCodeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LanguageCodeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

