/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.FormIntroduction;
import com.mypurecloud.sdk.v2.model.FormMessage;
import com.mypurecloud.sdk.v2.model.FormPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Form configuration for response management")
public class Form
implements Serializable {
    private String formDescription = null;
    private FormMessage receivedMessage = null;
    private FormMessage replyMessage = null;
    private FormIntroduction introduction = null;
    private List<FormPage> formPages = null;
    private Boolean showSummary = null;

    public Form() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.formPages = new ArrayList<FormPage>();
        }
    }

    public Form formDescription(String formDescription) {
        this.formDescription = formDescription;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Description of the form")
    @JsonProperty(value="formDescription")
    public String getFormDescription() {
        return this.formDescription;
    }

    public void setFormDescription(String formDescription) {
        this.formDescription = formDescription;
    }

    public Form receivedMessage(FormMessage receivedMessage) {
        this.receivedMessage = receivedMessage;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message displayed when response is received")
    @JsonProperty(value="receivedMessage")
    public FormMessage getReceivedMessage() {
        return this.receivedMessage;
    }

    public void setReceivedMessage(FormMessage receivedMessage) {
        this.receivedMessage = receivedMessage;
    }

    public Form replyMessage(FormMessage replyMessage) {
        this.replyMessage = replyMessage;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message displayed as reply")
    @JsonProperty(value="replyMessage")
    public FormMessage getReplyMessage() {
        return this.replyMessage;
    }

    public void setReplyMessage(FormMessage replyMessage) {
        this.replyMessage = replyMessage;
    }

    public Form introduction(FormIntroduction introduction) {
        this.introduction = introduction;
        return this;
    }

    @ApiModelProperty(example="null", value="Introduction section of the form")
    @JsonProperty(value="introduction")
    public FormIntroduction getIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(FormIntroduction introduction) {
        this.introduction = introduction;
    }

    public Form formPages(List<FormPage> formPages) {
        this.formPages = formPages;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Pages of the form")
    @JsonProperty(value="formPages")
    public List<FormPage> getFormPages() {
        return this.formPages;
    }

    public void setFormPages(List<FormPage> formPages) {
        this.formPages = formPages;
    }

    public Form showSummary(Boolean showSummary) {
        this.showSummary = showSummary;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether to show a summary after form completion")
    @JsonProperty(value="showSummary")
    public Boolean getShowSummary() {
        return this.showSummary;
    }

    public void setShowSummary(Boolean showSummary) {
        this.showSummary = showSummary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Form form = (Form)o;
        return Objects.equals(this.formDescription, form.formDescription) && Objects.equals(this.receivedMessage, form.receivedMessage) && Objects.equals(this.replyMessage, form.replyMessage) && Objects.equals(this.introduction, form.introduction) && Objects.equals(this.formPages, form.formPages) && Objects.equals(this.showSummary, form.showSummary);
    }

    public int hashCode() {
        return Objects.hash(this.formDescription, this.receivedMessage, this.replyMessage, this.introduction, this.formPages, this.showSummary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Form {\n");
        sb.append("    formDescription: ").append(this.toIndentedString(this.formDescription)).append("\n");
        sb.append("    receivedMessage: ").append(this.toIndentedString(this.receivedMessage)).append("\n");
        sb.append("    replyMessage: ").append(this.toIndentedString(this.replyMessage)).append("\n");
        sb.append("    introduction: ").append(this.toIndentedString(this.introduction)).append("\n");
        sb.append("    formPages: ").append(this.toIndentedString(this.formPages)).append("\n");
        sb.append("    showSummary: ").append(this.toIndentedString(this.showSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

