/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FileUploadMode
implements Serializable {
    private List<FileTypesEnum> fileTypes = null;
    private Long maxFileSizeKB = null;

    public FileUploadMode() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.fileTypes = new ArrayList<FileTypesEnum>();
        }
    }

    public FileUploadMode fileTypes(List<FileTypesEnum> fileTypes) {
        this.fileTypes = fileTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of supported content types for uploading files.")
    @JsonProperty(value="fileTypes")
    public List<FileTypesEnum> getFileTypes() {
        return this.fileTypes;
    }

    public void setFileTypes(List<FileTypesEnum> fileTypes) {
        this.fileTypes = fileTypes;
    }

    public FileUploadMode maxFileSizeKB(Long maxFileSizeKB) {
        this.maxFileSizeKB = maxFileSizeKB;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum file size for file uploads in kilobytes. Default is 10240 (10 MB)")
    @JsonProperty(value="maxFileSizeKB")
    public Long getMaxFileSizeKB() {
        return this.maxFileSizeKB;
    }

    public void setMaxFileSizeKB(Long maxFileSizeKB) {
        this.maxFileSizeKB = maxFileSizeKB;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileUploadMode fileUploadMode = (FileUploadMode)o;
        return Objects.equals(this.fileTypes, fileUploadMode.fileTypes) && Objects.equals(this.maxFileSizeKB, fileUploadMode.maxFileSizeKB);
    }

    public int hashCode() {
        return Objects.hash(this.fileTypes, this.maxFileSizeKB);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileUploadMode {\n");
        sb.append("    fileTypes: ").append(this.toIndentedString(this.fileTypes)).append("\n");
        sb.append("    maxFileSizeKB: ").append(this.toIndentedString(this.maxFileSizeKB)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FileTypesEnumDeserializer.class)
    public static enum FileTypesEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IMAGE_JPEG("image/jpeg"),
        IMAGE_GIF("image/gif"),
        IMAGE_PNG("image/png");

        private String value;

        private FileTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FileTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FileTypesEnum value : FileTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FileTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FileTypesEnumDeserializer
    extends StdDeserializer<FileTypesEnum> {
        public FileTypesEnumDeserializer() {
            super(FileTypesEnumDeserializer.class);
        }

        public FileTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FileTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

