/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ContactColumnConditionSettings
implements Serializable {
    private String columnName = null;
    private OperatorEnum operator = null;
    private String value = null;
    private ValueTypeEnum valueType = null;

    public ContactColumnConditionSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ContactColumnConditionSettings columnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the contact list column to evaluate.")
    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public ContactColumnConditionSettings operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The operator to use when comparing values.")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public ContactColumnConditionSettings value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="For Numeric: &#39;1234&#39;, &#39;1234.56&#39;, &#39;$1,234.56&#39;. For DateTime: &#39;2022-01-01T12:01:23.456-0000&#39;. For Period: &#39;P1DT1H1M&#39;. ", required=true, value="The value to compare against the contact's data.")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ContactColumnConditionSettings valueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The data type the value should be treated as.")
    @JsonProperty(value="valueType")
    public ValueTypeEnum getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactColumnConditionSettings contactColumnConditionSettings = (ContactColumnConditionSettings)o;
        return Objects.equals(this.columnName, contactColumnConditionSettings.columnName) && Objects.equals((Object)this.operator, (Object)contactColumnConditionSettings.operator) && Objects.equals(this.value, contactColumnConditionSettings.value) && Objects.equals((Object)this.valueType, (Object)contactColumnConditionSettings.valueType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnName, this.operator, this.value, this.valueType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactColumnConditionSettings {\n");
        sb.append("    columnName: ").append(this.toIndentedString(this.columnName)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString((Object)this.valueType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EQUALS("Equals"),
        LESSTHAN("LessThan"),
        LESSTHANEQUALS("LessThanEquals"),
        GREATERTHAN("GreaterThan"),
        GREATERTHANEQUALS("GreaterThanEquals"),
        CONTAINS("Contains"),
        BEGINSWITH("BeginsWith"),
        ENDSWITH("EndsWith"),
        BEFORE("Before"),
        AFTER("After");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ValueTypeEnumDeserializer.class)
    public static enum ValueTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DATETIME("DateTime"),
        NUMERIC("Numeric"),
        PERIOD("Period"),
        STRING("String");

        private String value;

        private ValueTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ValueTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ValueTypeEnum value : ValueTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ValueTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ValueTypeEnumDeserializer
    extends StdDeserializer<ValueTypeEnum> {
        public ValueTypeEnumDeserializer() {
            super(ValueTypeEnumDeserializer.class);
        }

        public ValueTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ValueTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

