/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.ChatReaction;
import com.mypurecloud.sdk.v2.model.Entity;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChatMessageResponse
implements Serializable {
    private String id = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String toJid = null;
    private String jid = null;
    private String body = null;
    private Map<String, String> mentions = null;
    private Boolean edited = null;
    private Boolean attachmentDeleted = null;
    private String fileUri = null;
    private Entity thread = null;
    private Entity parentThread = null;
    private AddressableEntityRef user = null;
    private AddressableEntityRef toUser = null;
    private List<ChatReaction> reactions = null;

    public ChatMessageResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.reactions = new ArrayList<ChatReaction>();
        }
    }

    public ChatMessageResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the message")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ChatMessageResponse dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message's created time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public ChatMessageResponse dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Message's last updated time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public ChatMessageResponse toJid(String toJid) {
        this.toJid = toJid;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Jid of message's recipient (roomJid or userJid)")
    @JsonProperty(value="toJid")
    public String getToJid() {
        return this.toJid;
    }

    public void setToJid(String toJid) {
        this.toJid = toJid;
    }

    public ChatMessageResponse jid(String jid) {
        this.jid = jid;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Jid of message's sender (userJid)")
    @JsonProperty(value="jid")
    public String getJid() {
        return this.jid;
    }

    public void setJid(String jid) {
        this.jid = jid;
    }

    public ChatMessageResponse body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message's body")
    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public ChatMessageResponse mentions(Map<String, String> mentions) {
        this.mentions = mentions;
        return this;
    }

    @ApiModelProperty(example="null", value="Message's mentions")
    @JsonProperty(value="mentions")
    public Map<String, String> getMentions() {
        return this.mentions;
    }

    public void setMentions(Map<String, String> mentions) {
        this.mentions = mentions;
    }

    public ChatMessageResponse edited(Boolean edited) {
        this.edited = edited;
        return this;
    }

    @ApiModelProperty(example="null", value="If message was edited")
    @JsonProperty(value="edited")
    public Boolean getEdited() {
        return this.edited;
    }

    public void setEdited(Boolean edited) {
        this.edited = edited;
    }

    public ChatMessageResponse attachmentDeleted(Boolean attachmentDeleted) {
        this.attachmentDeleted = attachmentDeleted;
        return this;
    }

    @ApiModelProperty(example="null", value="If message's attachment was deleted")
    @JsonProperty(value="attachmentDeleted")
    public Boolean getAttachmentDeleted() {
        return this.attachmentDeleted;
    }

    public void setAttachmentDeleted(Boolean attachmentDeleted) {
        this.attachmentDeleted = attachmentDeleted;
    }

    public ChatMessageResponse fileUri(String fileUri) {
        this.fileUri = fileUri;
        return this;
    }

    @ApiModelProperty(example="null", value="URI of file attachment")
    @JsonProperty(value="fileUri")
    public String getFileUri() {
        return this.fileUri;
    }

    public void setFileUri(String fileUri) {
        this.fileUri = fileUri;
    }

    public ChatMessageResponse thread(Entity thread) {
        this.thread = thread;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id for a thread this message corresponds to")
    @JsonProperty(value="thread")
    public Entity getThread() {
        return this.thread;
    }

    public void setThread(Entity thread) {
        this.thread = thread;
    }

    public ChatMessageResponse parentThread(Entity parentThread) {
        this.parentThread = parentThread;
        return this;
    }

    @ApiModelProperty(example="null", value="Parent thread id for thread replies")
    @JsonProperty(value="parentThread")
    public Entity getParentThread() {
        return this.parentThread;
    }

    public void setParentThread(Entity parentThread) {
        this.parentThread = parentThread;
    }

    public ChatMessageResponse user(AddressableEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who sent the message")
    @JsonProperty(value="user")
    public AddressableEntityRef getUser() {
        return this.user;
    }

    public void setUser(AddressableEntityRef user) {
        this.user = user;
    }

    public ChatMessageResponse toUser(AddressableEntityRef toUser) {
        this.toUser = toUser;
        return this;
    }

    @ApiModelProperty(example="null", value="The receiving user of the message")
    @JsonProperty(value="toUser")
    public AddressableEntityRef getToUser() {
        return this.toUser;
    }

    public void setToUser(AddressableEntityRef toUser) {
        this.toUser = toUser;
    }

    public ChatMessageResponse reactions(List<ChatReaction> reactions) {
        this.reactions = reactions;
        return this;
    }

    @ApiModelProperty(example="null", value="The emoji reactions to this message")
    @JsonProperty(value="reactions")
    public List<ChatReaction> getReactions() {
        return this.reactions;
    }

    public void setReactions(List<ChatReaction> reactions) {
        this.reactions = reactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatMessageResponse chatMessageResponse = (ChatMessageResponse)o;
        return Objects.equals(this.id, chatMessageResponse.id) && Objects.equals(this.dateCreated, chatMessageResponse.dateCreated) && Objects.equals(this.dateModified, chatMessageResponse.dateModified) && Objects.equals(this.toJid, chatMessageResponse.toJid) && Objects.equals(this.jid, chatMessageResponse.jid) && Objects.equals(this.body, chatMessageResponse.body) && Objects.equals(this.mentions, chatMessageResponse.mentions) && Objects.equals(this.edited, chatMessageResponse.edited) && Objects.equals(this.attachmentDeleted, chatMessageResponse.attachmentDeleted) && Objects.equals(this.fileUri, chatMessageResponse.fileUri) && Objects.equals(this.thread, chatMessageResponse.thread) && Objects.equals(this.parentThread, chatMessageResponse.parentThread) && Objects.equals(this.user, chatMessageResponse.user) && Objects.equals(this.toUser, chatMessageResponse.toUser) && Objects.equals(this.reactions, chatMessageResponse.reactions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.dateCreated, this.dateModified, this.toJid, this.jid, this.body, this.mentions, this.edited, this.attachmentDeleted, this.fileUri, this.thread, this.parentThread, this.user, this.toUser, this.reactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChatMessageResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    toJid: ").append(this.toIndentedString(this.toJid)).append("\n");
        sb.append("    jid: ").append(this.toIndentedString(this.jid)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    mentions: ").append(this.toIndentedString(this.mentions)).append("\n");
        sb.append("    edited: ").append(this.toIndentedString(this.edited)).append("\n");
        sb.append("    attachmentDeleted: ").append(this.toIndentedString(this.attachmentDeleted)).append("\n");
        sb.append("    fileUri: ").append(this.toIndentedString(this.fileUri)).append("\n");
        sb.append("    thread: ").append(this.toIndentedString(this.thread)).append("\n");
        sb.append("    parentThread: ").append(this.toIndentedString(this.parentThread)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    toUser: ").append(this.toIndentedString(this.toUser)).append("\n");
        sb.append("    reactions: ").append(this.toIndentedString(this.reactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

