/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BuShortTermForecastReference;
import com.mypurecloud.sdk.v2.model.CreateStaffingGroupAllocation;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CapacityPlanRequest
implements Serializable {
    private String name = null;
    private String description = null;
    private LocalDate startBusinessUnitDate = null;
    private LocalDate endBusinessUnitDate = null;
    private BuShortTermForecastReference forecast = null;
    private Double fullTimeEquivalentWeeklyHours = null;
    private List<CreateStaffingGroupAllocation> staffingGroupAllocations = null;

    public CapacityPlanRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.staffingGroupAllocations = new ArrayList<CreateStaffingGroupAllocation>();
        }
    }

    public CapacityPlanRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the capacity plan")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CapacityPlanRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Description of the capacity plan")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CapacityPlanRequest startBusinessUnitDate(LocalDate startBusinessUnitDate) {
        this.startBusinessUnitDate = startBusinessUnitDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The start date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="startBusinessUnitDate")
    public LocalDate getStartBusinessUnitDate() {
        return this.startBusinessUnitDate;
    }

    public void setStartBusinessUnitDate(LocalDate startBusinessUnitDate) {
        this.startBusinessUnitDate = startBusinessUnitDate;
    }

    public CapacityPlanRequest endBusinessUnitDate(LocalDate endBusinessUnitDate) {
        this.endBusinessUnitDate = endBusinessUnitDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The end date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="endBusinessUnitDate")
    public LocalDate getEndBusinessUnitDate() {
        return this.endBusinessUnitDate;
    }

    public void setEndBusinessUnitDate(LocalDate endBusinessUnitDate) {
        this.endBusinessUnitDate = endBusinessUnitDate;
    }

    public CapacityPlanRequest forecast(BuShortTermForecastReference forecast) {
        this.forecast = forecast;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The selected forecast for this capacity plan. Null when main forecast is used in the future")
    @JsonProperty(value="forecast")
    public BuShortTermForecastReference getForecast() {
        return this.forecast;
    }

    public void setForecast(BuShortTermForecastReference forecast) {
        this.forecast = forecast;
    }

    public CapacityPlanRequest fullTimeEquivalentWeeklyHours(Double fullTimeEquivalentWeeklyHours) {
        this.fullTimeEquivalentWeeklyHours = fullTimeEquivalentWeeklyHours;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The weekly hours used to calculate full time equivalent agents")
    @JsonProperty(value="fullTimeEquivalentWeeklyHours")
    public Double getFullTimeEquivalentWeeklyHours() {
        return this.fullTimeEquivalentWeeklyHours;
    }

    public void setFullTimeEquivalentWeeklyHours(Double fullTimeEquivalentWeeklyHours) {
        this.fullTimeEquivalentWeeklyHours = fullTimeEquivalentWeeklyHours;
    }

    public CapacityPlanRequest staffingGroupAllocations(List<CreateStaffingGroupAllocation> staffingGroupAllocations) {
        this.staffingGroupAllocations = staffingGroupAllocations;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of staffing group allocations to be used for the capacity plan")
    @JsonProperty(value="staffingGroupAllocations")
    public List<CreateStaffingGroupAllocation> getStaffingGroupAllocations() {
        return this.staffingGroupAllocations;
    }

    public void setStaffingGroupAllocations(List<CreateStaffingGroupAllocation> staffingGroupAllocations) {
        this.staffingGroupAllocations = staffingGroupAllocations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapacityPlanRequest capacityPlanRequest = (CapacityPlanRequest)o;
        return Objects.equals(this.name, capacityPlanRequest.name) && Objects.equals(this.description, capacityPlanRequest.description) && Objects.equals(this.startBusinessUnitDate, capacityPlanRequest.startBusinessUnitDate) && Objects.equals(this.endBusinessUnitDate, capacityPlanRequest.endBusinessUnitDate) && Objects.equals(this.forecast, capacityPlanRequest.forecast) && Objects.equals(this.fullTimeEquivalentWeeklyHours, capacityPlanRequest.fullTimeEquivalentWeeklyHours) && Objects.equals(this.staffingGroupAllocations, capacityPlanRequest.staffingGroupAllocations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.startBusinessUnitDate, this.endBusinessUnitDate, this.forecast, this.fullTimeEquivalentWeeklyHours, this.staffingGroupAllocations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapacityPlanRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    startBusinessUnitDate: ").append(this.toIndentedString(this.startBusinessUnitDate)).append("\n");
        sb.append("    endBusinessUnitDate: ").append(this.toIndentedString(this.endBusinessUnitDate)).append("\n");
        sb.append("    forecast: ").append(this.toIndentedString(this.forecast)).append("\n");
        sb.append("    fullTimeEquivalentWeeklyHours: ").append(this.toIndentedString(this.fullTimeEquivalentWeeklyHours)).append("\n");
        sb.append("    staffingGroupAllocations: ").append(this.toIndentedString(this.staffingGroupAllocations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

