/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.JsonSchemaWithDefinitions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Request to update an existing Business Rules Schema")
public class BusinessRulesSchemaUpdateRequest
implements Serializable {
    private Integer version = null;
    private Boolean enabled = null;
    private JsonSchemaWithDefinitions jsonSchema = null;

    public BusinessRulesSchemaUpdateRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public BusinessRulesSchemaUpdateRequest version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The schema's version, a positive integer. Required for updates.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public BusinessRulesSchemaUpdateRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="The schema's enabled/disabled status. A disabled schema cannot be assigned to any other entities, but the data on those entities from the schema still exists.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public BusinessRulesSchemaUpdateRequest jsonSchema(JsonSchemaWithDefinitions jsonSchema) {
        this.jsonSchema = jsonSchema;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A JSON schema defining the extension to the built-in entity type.")
    @JsonProperty(value="jsonSchema")
    public JsonSchemaWithDefinitions getJsonSchema() {
        return this.jsonSchema;
    }

    public void setJsonSchema(JsonSchemaWithDefinitions jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessRulesSchemaUpdateRequest businessRulesSchemaUpdateRequest = (BusinessRulesSchemaUpdateRequest)o;
        return Objects.equals(this.version, businessRulesSchemaUpdateRequest.version) && Objects.equals(this.enabled, businessRulesSchemaUpdateRequest.enabled) && Objects.equals(this.jsonSchema, businessRulesSchemaUpdateRequest.jsonSchema);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.enabled, this.jsonSchema);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessRulesSchemaUpdateRequest {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    jsonSchema: ").append(this.toIndentedString(this.jsonSchema)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

