/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class AnalyticsEvaluation
implements Serializable {
    private Boolean assigneeApplicable = null;
    private String assigneeId = null;
    private String calibrationId = null;
    private String contextId = null;
    private Boolean deleted = null;
    private String evaluationId = null;
    private EvaluationStatusEnum evaluationStatus = null;
    private String evaluatorId = null;
    private Date eventTime = null;
    private String formId = null;
    private String formName = null;
    private String queueId = null;
    private Boolean released = null;
    private Boolean rescored = null;
    private Boolean systemSubmitted = null;
    private String userId = null;
    private Long oTotalCriticalScore = null;
    private Long oTotalScore = null;

    public AnalyticsEvaluation() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public AnalyticsEvaluation assigneeApplicable(Boolean assigneeApplicable) {
        this.assigneeApplicable = assigneeApplicable;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether an assignee is applicable for the evaluation. Set to false when assignee is not applicable")
    @JsonProperty(value="assigneeApplicable")
    public Boolean getAssigneeApplicable() {
        return this.assigneeApplicable;
    }

    public void setAssigneeApplicable(Boolean assigneeApplicable) {
        this.assigneeApplicable = assigneeApplicable;
    }

    public AnalyticsEvaluation assigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    @ApiModelProperty(example="null", value="UserId of the assignee")
    @JsonProperty(value="assigneeId")
    public String getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
    }

    public AnalyticsEvaluation calibrationId(String calibrationId) {
        this.calibrationId = calibrationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The calibration ID used for the purpose of training evaluators")
    @JsonProperty(value="calibrationId")
    public String getCalibrationId() {
        return this.calibrationId;
    }

    public void setCalibrationId(String calibrationId) {
        this.calibrationId = calibrationId;
    }

    public AnalyticsEvaluation contextId(String contextId) {
        this.contextId = contextId;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique identifier for an evaluation form, regardless of version")
    @JsonProperty(value="contextId")
    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public AnalyticsEvaluation deleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the evaluation has been deleted")
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public AnalyticsEvaluation evaluationId(String evaluationId) {
        this.evaluationId = evaluationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the evaluation")
    @JsonProperty(value="evaluationId")
    public String getEvaluationId() {
        return this.evaluationId;
    }

    public void setEvaluationId(String evaluationId) {
        this.evaluationId = evaluationId;
    }

    public AnalyticsEvaluation evaluationStatus(EvaluationStatusEnum evaluationStatus) {
        this.evaluationStatus = evaluationStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of evaluation")
    @JsonProperty(value="evaluationStatus")
    public EvaluationStatusEnum getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public void setEvaluationStatus(EvaluationStatusEnum evaluationStatus) {
        this.evaluationStatus = evaluationStatus;
    }

    public AnalyticsEvaluation evaluatorId(String evaluatorId) {
        this.evaluatorId = evaluatorId;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique identifier of the user who evaluated the interaction")
    @JsonProperty(value="evaluatorId")
    public String getEvaluatorId() {
        return this.evaluatorId;
    }

    public void setEvaluatorId(String evaluatorId) {
        this.evaluatorId = evaluatorId;
    }

    public AnalyticsEvaluation eventTime(Date eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies when an evaluation occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventTime")
    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public AnalyticsEvaluation formId(String formId) {
        this.formId = formId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the evaluation form used")
    @JsonProperty(value="formId")
    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public AnalyticsEvaluation formName(String formName) {
        this.formName = formName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the evaluation form used")
    @JsonProperty(value="formName")
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public AnalyticsEvaluation queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the associated queue")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public AnalyticsEvaluation released(Boolean released) {
        this.released = released;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the evaluation has been released")
    @JsonProperty(value="released")
    public Boolean getReleased() {
        return this.released;
    }

    public void setReleased(Boolean released) {
        this.released = released;
    }

    public AnalyticsEvaluation rescored(Boolean rescored) {
        this.rescored = rescored;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the evaluation has been rescored at least once")
    @JsonProperty(value="rescored")
    public Boolean getRescored() {
        return this.rescored;
    }

    public void setRescored(Boolean rescored) {
        this.rescored = rescored;
    }

    public AnalyticsEvaluation systemSubmitted(Boolean systemSubmitted) {
        this.systemSubmitted = systemSubmitted;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the evaluation was auto submitted by the system")
    @JsonProperty(value="systemSubmitted")
    public Boolean getSystemSubmitted() {
        return this.systemSubmitted;
    }

    public void setSystemSubmitted(Boolean systemSubmitted) {
        this.systemSubmitted = systemSubmitted;
    }

    public AnalyticsEvaluation userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the agent the evaluation was performed against")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public AnalyticsEvaluation oTotalCriticalScore(Long oTotalCriticalScore) {
        this.oTotalCriticalScore = oTotalCriticalScore;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="oTotalCriticalScore")
    public Long getOTotalCriticalScore() {
        return this.oTotalCriticalScore;
    }

    public void setOTotalCriticalScore(Long oTotalCriticalScore) {
        this.oTotalCriticalScore = oTotalCriticalScore;
    }

    public AnalyticsEvaluation oTotalScore(Long oTotalScore) {
        this.oTotalScore = oTotalScore;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="oTotalScore")
    public Long getOTotalScore() {
        return this.oTotalScore;
    }

    public void setOTotalScore(Long oTotalScore) {
        this.oTotalScore = oTotalScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsEvaluation analyticsEvaluation = (AnalyticsEvaluation)o;
        return Objects.equals(this.assigneeApplicable, analyticsEvaluation.assigneeApplicable) && Objects.equals(this.assigneeId, analyticsEvaluation.assigneeId) && Objects.equals(this.calibrationId, analyticsEvaluation.calibrationId) && Objects.equals(this.contextId, analyticsEvaluation.contextId) && Objects.equals(this.deleted, analyticsEvaluation.deleted) && Objects.equals(this.evaluationId, analyticsEvaluation.evaluationId) && Objects.equals((Object)this.evaluationStatus, (Object)analyticsEvaluation.evaluationStatus) && Objects.equals(this.evaluatorId, analyticsEvaluation.evaluatorId) && Objects.equals(this.eventTime, analyticsEvaluation.eventTime) && Objects.equals(this.formId, analyticsEvaluation.formId) && Objects.equals(this.formName, analyticsEvaluation.formName) && Objects.equals(this.queueId, analyticsEvaluation.queueId) && Objects.equals(this.released, analyticsEvaluation.released) && Objects.equals(this.rescored, analyticsEvaluation.rescored) && Objects.equals(this.systemSubmitted, analyticsEvaluation.systemSubmitted) && Objects.equals(this.userId, analyticsEvaluation.userId) && Objects.equals(this.oTotalCriticalScore, analyticsEvaluation.oTotalCriticalScore) && Objects.equals(this.oTotalScore, analyticsEvaluation.oTotalScore);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assigneeApplicable, this.assigneeId, this.calibrationId, this.contextId, this.deleted, this.evaluationId, this.evaluationStatus, this.evaluatorId, this.eventTime, this.formId, this.formName, this.queueId, this.released, this.rescored, this.systemSubmitted, this.userId, this.oTotalCriticalScore, this.oTotalScore});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsEvaluation {\n");
        sb.append("    assigneeApplicable: ").append(this.toIndentedString(this.assigneeApplicable)).append("\n");
        sb.append("    assigneeId: ").append(this.toIndentedString(this.assigneeId)).append("\n");
        sb.append("    calibrationId: ").append(this.toIndentedString(this.calibrationId)).append("\n");
        sb.append("    contextId: ").append(this.toIndentedString(this.contextId)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    evaluationId: ").append(this.toIndentedString(this.evaluationId)).append("\n");
        sb.append("    evaluationStatus: ").append(this.toIndentedString((Object)this.evaluationStatus)).append("\n");
        sb.append("    evaluatorId: ").append(this.toIndentedString(this.evaluatorId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    formId: ").append(this.toIndentedString(this.formId)).append("\n");
        sb.append("    formName: ").append(this.toIndentedString(this.formName)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    released: ").append(this.toIndentedString(this.released)).append("\n");
        sb.append("    rescored: ").append(this.toIndentedString(this.rescored)).append("\n");
        sb.append("    systemSubmitted: ").append(this.toIndentedString(this.systemSubmitted)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    oTotalCriticalScore: ").append(this.toIndentedString(this.oTotalCriticalScore)).append("\n");
        sb.append("    oTotalScore: ").append(this.toIndentedString(this.oTotalScore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=EvaluationStatusEnumDeserializer.class)
    public static enum EvaluationStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FINISHED("Finished"),
        INPROGRESS("InProgress"),
        INREVIEW("InReview"),
        PENDING("Pending"),
        RETRACTED("Retracted");

        private String value;

        private EvaluationStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EvaluationStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EvaluationStatusEnum value : EvaluationStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EvaluationStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EvaluationStatusEnumDeserializer
    extends StdDeserializer<EvaluationStatusEnum> {
        public EvaluationStatusEnumDeserializer() {
            super(EvaluationStatusEnumDeserializer.class);
        }

        public EvaluationStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EvaluationStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

