/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.LearningModuleJobRequest;
import java.util.HashMap;
import java.util.Map;

public class PostLearningModuleJobsRequest {
    private String moduleId;
    private LearningModuleJobRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public PostLearningModuleJobsRequest withModuleId(String moduleId) {
        this.setModuleId(moduleId);
        return this;
    }

    public LearningModuleJobRequest getBody() {
        return this.body;
    }

    public void setBody(LearningModuleJobRequest body) {
        this.body = body;
    }

    public PostLearningModuleJobsRequest withBody(LearningModuleJobRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostLearningModuleJobsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<LearningModuleJobRequest> withHttpInfo() {
        if (this.moduleId == null) {
            throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for PostLearningModuleJobsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostLearningModuleJobsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/learning/modules/{moduleId}/jobs").withPathParameter("moduleId", this.moduleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String moduleId, LearningModuleJobRequest body) {
        return new Builder().withRequiredParams(moduleId, body);
    }

    public static class Builder {
        private final PostLearningModuleJobsRequest request = new PostLearningModuleJobsRequest();

        private Builder() {
        }

        public Builder withModuleId(String moduleId) {
            this.request.setModuleId(moduleId);
            return this;
        }

        public Builder withBody(LearningModuleJobRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String moduleId, LearningModuleJobRequest body) {
            this.request.setModuleId(moduleId);
            this.request.setBody(body);
            return this;
        }

        public PostLearningModuleJobsRequest build() {
            if (this.request.moduleId == null) {
                throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for PostLearningModuleJobsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostLearningModuleJobsRequest.");
            }
            return this.request;
        }
    }
}

