/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AuthzDivision;
import java.util.HashMap;
import java.util.Map;

public class PostAuthorizationDivisionRestoreRequest {
    private String divisionId;
    private AuthzDivision body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDivisionId() {
        return this.divisionId;
    }

    public void setDivisionId(String divisionId) {
        this.divisionId = divisionId;
    }

    public PostAuthorizationDivisionRestoreRequest withDivisionId(String divisionId) {
        this.setDivisionId(divisionId);
        return this;
    }

    public AuthzDivision getBody() {
        return this.body;
    }

    public void setBody(AuthzDivision body) {
        this.body = body;
    }

    public PostAuthorizationDivisionRestoreRequest withBody(AuthzDivision body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostAuthorizationDivisionRestoreRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<AuthzDivision> withHttpInfo() {
        if (this.divisionId == null) {
            throw new IllegalStateException("Missing the required parameter 'divisionId' when building request for PostAuthorizationDivisionRestoreRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAuthorizationDivisionRestoreRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/authorization/divisions/{divisionId}/restore").withPathParameter("divisionId", this.divisionId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String divisionId, AuthzDivision body) {
        return new Builder().withRequiredParams(divisionId, body);
    }

    public static class Builder {
        private final PostAuthorizationDivisionRestoreRequest request = new PostAuthorizationDivisionRestoreRequest();

        private Builder() {
        }

        public Builder withDivisionId(String divisionId) {
            this.request.setDivisionId(divisionId);
            return this;
        }

        public Builder withBody(AuthzDivision body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String divisionId, AuthzDivision body) {
            this.request.setDivisionId(divisionId);
            this.request.setBody(body);
            return this;
        }

        public PostAuthorizationDivisionRestoreRequest build() {
            if (this.request.divisionId == null) {
                throw new IllegalStateException("Missing the required parameter 'divisionId' when building request for PostAuthorizationDivisionRestoreRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAuthorizationDivisionRestoreRequest.");
            }
            return this.request;
        }
    }
}

