/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.LabelUpdateRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchKnowledgeKnowledgebaseLabelRequest {
    private String knowledgeBaseId;
    private String labelId;
    private LabelUpdateRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PatchKnowledgeKnowledgebaseLabelRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getLabelId() {
        return this.labelId;
    }

    public void setLabelId(String labelId) {
        this.labelId = labelId;
    }

    public PatchKnowledgeKnowledgebaseLabelRequest withLabelId(String labelId) {
        this.setLabelId(labelId);
        return this;
    }

    public LabelUpdateRequest getBody() {
        return this.body;
    }

    public void setBody(LabelUpdateRequest body) {
        this.body = body;
    }

    public PatchKnowledgeKnowledgebaseLabelRequest withBody(LabelUpdateRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchKnowledgeKnowledgebaseLabelRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<LabelUpdateRequest> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseLabelRequest.");
        }
        if (this.labelId == null) {
            throw new IllegalStateException("Missing the required parameter 'labelId' when building request for PatchKnowledgeKnowledgebaseLabelRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseLabelRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/labels/{labelId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("labelId", this.labelId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String labelId, LabelUpdateRequest body) {
        return new Builder().withRequiredParams(knowledgeBaseId, labelId, body);
    }

    public static class Builder {
        private final PatchKnowledgeKnowledgebaseLabelRequest request = new PatchKnowledgeKnowledgebaseLabelRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withLabelId(String labelId) {
            this.request.setLabelId(labelId);
            return this;
        }

        public Builder withBody(LabelUpdateRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String labelId, LabelUpdateRequest body) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setLabelId(labelId);
            this.request.setBody(body);
            return this;
        }

        public PatchKnowledgeKnowledgebaseLabelRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseLabelRequest.");
            }
            if (this.request.labelId == null) {
                throw new IllegalStateException("Missing the required parameter 'labelId' when building request for PatchKnowledgeKnowledgebaseLabelRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseLabelRequest.");
            }
            return this.request;
        }
    }
}

