/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SendMessageBody;
import java.util.HashMap;
import java.util.Map;

public class PatchChatsRoomMessageRequest {
    private String roomJid;
    private String messageId;
    private SendMessageBody body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoomJid() {
        return this.roomJid;
    }

    public void setRoomJid(String roomJid) {
        this.roomJid = roomJid;
    }

    public PatchChatsRoomMessageRequest withRoomJid(String roomJid) {
        this.setRoomJid(roomJid);
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public PatchChatsRoomMessageRequest withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public SendMessageBody getBody() {
        return this.body;
    }

    public void setBody(SendMessageBody body) {
        this.body = body;
    }

    public PatchChatsRoomMessageRequest withBody(SendMessageBody body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchChatsRoomMessageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SendMessageBody> withHttpInfo() {
        if (this.roomJid == null) {
            throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for PatchChatsRoomMessageRequest.");
        }
        if (this.messageId == null) {
            throw new IllegalStateException("Missing the required parameter 'messageId' when building request for PatchChatsRoomMessageRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchChatsRoomMessageRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/chats/rooms/{roomJid}/messages/{messageId}").withPathParameter("roomJid", this.roomJid).withPathParameter("messageId", this.messageId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roomJid, String messageId, SendMessageBody body) {
        return new Builder().withRequiredParams(roomJid, messageId, body);
    }

    public static class Builder {
        private final PatchChatsRoomMessageRequest request = new PatchChatsRoomMessageRequest();

        private Builder() {
        }

        public Builder withRoomJid(String roomJid) {
            this.request.setRoomJid(roomJid);
            return this;
        }

        public Builder withMessageId(String messageId) {
            this.request.setMessageId(messageId);
            return this;
        }

        public Builder withBody(SendMessageBody body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String roomJid, String messageId, SendMessageBody body) {
            this.request.setRoomJid(roomJid);
            this.request.setMessageId(messageId);
            this.request.setBody(body);
            return this;
        }

        public PatchChatsRoomMessageRequest build() {
            if (this.request.roomJid == null) {
                throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for PatchChatsRoomMessageRequest.");
            }
            if (this.request.messageId == null) {
                throw new IllegalStateException("Missing the required parameter 'messageId' when building request for PatchChatsRoomMessageRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchChatsRoomMessageRequest.");
            }
            return this.request;
        }
    }
}

