/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class GetBillingContractsInvoicesRequest {
    private String before;
    private String after;
    private String pageSize;
    private LocalDate dateStart;
    private LocalDate dateEnd;
    private String paymentStatus;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getBefore() {
        return this.before;
    }

    public void setBefore(String before) {
        this.before = before;
    }

    public GetBillingContractsInvoicesRequest withBefore(String before) {
        this.setBefore(before);
        return this;
    }

    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public GetBillingContractsInvoicesRequest withAfter(String after) {
        this.setAfter(after);
        return this;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public GetBillingContractsInvoicesRequest withPageSize(String pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public LocalDate getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
    }

    public GetBillingContractsInvoicesRequest withDateStart(LocalDate dateStart) {
        this.setDateStart(dateStart);
        return this;
    }

    public LocalDate getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    public GetBillingContractsInvoicesRequest withDateEnd(LocalDate dateEnd) {
        this.setDateEnd(dateEnd);
        return this;
    }

    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public GetBillingContractsInvoicesRequest withPaymentStatus(String paymentStatus) {
        this.setPaymentStatus(paymentStatus);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetBillingContractsInvoicesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        return ApiRequestBuilder.create("GET", "/api/v2/billing/contracts/invoices").withQueryParameters("before", "", this.before).withQueryParameters("after", "", this.after).withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("dateStart", "", this.dateStart).withQueryParameters("dateEnd", "", this.dateEnd).withQueryParameters("paymentStatus", "", this.paymentStatus).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final GetBillingContractsInvoicesRequest request = new GetBillingContractsInvoicesRequest();

        private Builder() {
        }

        public Builder withBefore(String before) {
            this.request.setBefore(before);
            return this;
        }

        public Builder withAfter(String after) {
            this.request.setAfter(after);
            return this;
        }

        public Builder withPageSize(String pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withDateStart(LocalDate dateStart) {
            this.request.setDateStart(dateStart);
            return this;
        }

        public Builder withDateEnd(LocalDate dateEnd) {
            this.request.setDateEnd(dateEnd);
            return this;
        }

        public Builder withPaymentStatus(String paymentStatus) {
            this.request.setPaymentStatus(paymentStatus);
            return this;
        }

        public Builder withPaymentStatus(paymentStatusValues paymentStatus) {
            this.request.setPaymentStatus(paymentStatus.toString());
            return this;
        }

        public GetBillingContractsInvoicesRequest build() {
            return this.request;
        }
    }

    public static enum paymentStatusValues {
        PAID("Paid"),
        UNPAID("UnPaid");

        private String value;

        private paymentStatusValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static paymentStatusValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (paymentStatusValues value : paymentStatusValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return paymentStatusValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

