/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteGreetingRequest;
import com.mypurecloud.sdk.v2.api.request.GetGreetingDownloadsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGreetingGroupsDownloadsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGreetingMediaRequest;
import com.mypurecloud.sdk.v2.api.request.GetGreetingRequest;
import com.mypurecloud.sdk.v2.api.request.GetGreetingUsersDownloadsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGroupGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.PostUserGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.PutGreetingRequest;
import com.mypurecloud.sdk.v2.api.request.PutGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.api.request.PutGroupGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.api.request.PutUserGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.model.DefaultGreetingList;
import com.mypurecloud.sdk.v2.model.DomainEntityListing;
import com.mypurecloud.sdk.v2.model.Greeting;
import com.mypurecloud.sdk.v2.model.GreetingListing;
import com.mypurecloud.sdk.v2.model.GreetingMediaInfo;
import java.io.IOException;

public class GreetingsApi {
    private final ApiClient pcapiClient;

    public GreetingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GreetingsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteGreeting(String greetingId) throws IOException, ApiException {
        this.deleteGreeting(this.createDeleteGreetingRequest(greetingId));
    }

    public ApiResponse<Void> deleteGreetingWithHttpInfo(String greetingId) throws IOException {
        return this.deleteGreeting(this.createDeleteGreetingRequest(greetingId).withHttpInfo());
    }

    private DeleteGreetingRequest createDeleteGreetingRequest(String greetingId) {
        return DeleteGreetingRequest.builder().withGreetingId(greetingId).build();
    }

    public void deleteGreeting(DeleteGreetingRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteGreeting(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Greeting getGreeting(String greetingId) throws IOException, ApiException {
        return this.getGreeting(this.createGetGreetingRequest(greetingId));
    }

    public ApiResponse<Greeting> getGreetingWithHttpInfo(String greetingId) throws IOException {
        return this.getGreeting(this.createGetGreetingRequest(greetingId).withHttpInfo());
    }

    private GetGreetingRequest createGetGreetingRequest(String greetingId) {
        return GetGreetingRequest.builder().withGreetingId(greetingId).build();
    }

    public Greeting getGreeting(GetGreetingRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Greeting> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Greeting>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Greeting> getGreeting(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Greeting>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GreetingMediaInfo getGreetingDownloads(String greetingId, String formatId) throws IOException, ApiException {
        return this.getGreetingDownloads(this.createGetGreetingDownloadsRequest(greetingId, formatId));
    }

    public ApiResponse<GreetingMediaInfo> getGreetingDownloadsWithHttpInfo(String greetingId, String formatId) throws IOException {
        return this.getGreetingDownloads(this.createGetGreetingDownloadsRequest(greetingId, formatId).withHttpInfo());
    }

    private GetGreetingDownloadsRequest createGetGreetingDownloadsRequest(String greetingId, String formatId) {
        return GetGreetingDownloadsRequest.builder().withGreetingId(greetingId).withFormatId(formatId).build();
    }

    public GreetingMediaInfo getGreetingDownloads(GetGreetingDownloadsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GreetingMediaInfo> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GreetingMediaInfo>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GreetingMediaInfo> getGreetingDownloads(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GreetingMediaInfo>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GreetingMediaInfo getGreetingGroupsDownloads(String greetingId, String formatId) throws IOException, ApiException {
        return this.getGreetingGroupsDownloads(this.createGetGreetingGroupsDownloadsRequest(greetingId, formatId));
    }

    public ApiResponse<GreetingMediaInfo> getGreetingGroupsDownloadsWithHttpInfo(String greetingId, String formatId) throws IOException {
        return this.getGreetingGroupsDownloads(this.createGetGreetingGroupsDownloadsRequest(greetingId, formatId).withHttpInfo());
    }

    private GetGreetingGroupsDownloadsRequest createGetGreetingGroupsDownloadsRequest(String greetingId, String formatId) {
        return GetGreetingGroupsDownloadsRequest.builder().withGreetingId(greetingId).withFormatId(formatId).build();
    }

    public GreetingMediaInfo getGreetingGroupsDownloads(GetGreetingGroupsDownloadsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GreetingMediaInfo> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GreetingMediaInfo>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GreetingMediaInfo> getGreetingGroupsDownloads(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GreetingMediaInfo>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GreetingMediaInfo getGreetingMedia(String greetingId, String formatId) throws IOException, ApiException {
        return this.getGreetingMedia(this.createGetGreetingMediaRequest(greetingId, formatId));
    }

    public ApiResponse<GreetingMediaInfo> getGreetingMediaWithHttpInfo(String greetingId, String formatId) throws IOException {
        return this.getGreetingMedia(this.createGetGreetingMediaRequest(greetingId, formatId).withHttpInfo());
    }

    private GetGreetingMediaRequest createGetGreetingMediaRequest(String greetingId, String formatId) {
        return GetGreetingMediaRequest.builder().withGreetingId(greetingId).withFormatId(formatId).build();
    }

    public GreetingMediaInfo getGreetingMedia(GetGreetingMediaRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GreetingMediaInfo> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GreetingMediaInfo>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GreetingMediaInfo> getGreetingMedia(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GreetingMediaInfo>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GreetingMediaInfo getGreetingUsersDownloads(String greetingId, String formatId) throws IOException, ApiException {
        return this.getGreetingUsersDownloads(this.createGetGreetingUsersDownloadsRequest(greetingId, formatId));
    }

    public ApiResponse<GreetingMediaInfo> getGreetingUsersDownloadsWithHttpInfo(String greetingId, String formatId) throws IOException {
        return this.getGreetingUsersDownloads(this.createGetGreetingUsersDownloadsRequest(greetingId, formatId).withHttpInfo());
    }

    private GetGreetingUsersDownloadsRequest createGetGreetingUsersDownloadsRequest(String greetingId, String formatId) {
        return GetGreetingUsersDownloadsRequest.builder().withGreetingId(greetingId).withFormatId(formatId).build();
    }

    public GreetingMediaInfo getGreetingUsersDownloads(GetGreetingUsersDownloadsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GreetingMediaInfo> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GreetingMediaInfo>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GreetingMediaInfo> getGreetingUsersDownloads(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GreetingMediaInfo>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DomainEntityListing getGreetings(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getGreetings(this.createGetGreetingsRequest(pageSize, pageNumber));
    }

    public ApiResponse<DomainEntityListing> getGreetingsWithHttpInfo(Integer pageSize, Integer pageNumber) throws IOException {
        return this.getGreetings(this.createGetGreetingsRequest(pageSize, pageNumber).withHttpInfo());
    }

    private GetGreetingsRequest createGetGreetingsRequest(Integer pageSize, Integer pageNumber) {
        return GetGreetingsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public DomainEntityListing getGreetings(GetGreetingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DomainEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DomainEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DomainEntityListing> getGreetings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DomainEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DefaultGreetingList getGreetingsDefaults() throws IOException, ApiException {
        return this.getGreetingsDefaults(this.createGetGreetingsDefaultsRequest());
    }

    public ApiResponse<DefaultGreetingList> getGreetingsDefaultsWithHttpInfo() throws IOException {
        return this.getGreetingsDefaults(this.createGetGreetingsDefaultsRequest().withHttpInfo());
    }

    private GetGreetingsDefaultsRequest createGetGreetingsDefaultsRequest() {
        return GetGreetingsDefaultsRequest.builder().build();
    }

    public DefaultGreetingList getGreetingsDefaults(GetGreetingsDefaultsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DefaultGreetingList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DefaultGreetingList> getGreetingsDefaults(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DefaultGreetingList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GreetingListing getGroupGreetings(String groupId, Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getGroupGreetings(this.createGetGroupGreetingsRequest(groupId, pageSize, pageNumber));
    }

    public ApiResponse<GreetingListing> getGroupGreetingsWithHttpInfo(String groupId, Integer pageSize, Integer pageNumber) throws IOException {
        return this.getGroupGreetings(this.createGetGroupGreetingsRequest(groupId, pageSize, pageNumber).withHttpInfo());
    }

    private GetGroupGreetingsRequest createGetGroupGreetingsRequest(String groupId, Integer pageSize, Integer pageNumber) {
        return GetGroupGreetingsRequest.builder().withGroupId(groupId).withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public GreetingListing getGroupGreetings(GetGroupGreetingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GreetingListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GreetingListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GreetingListing> getGroupGreetings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GreetingListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DefaultGreetingList getGroupGreetingsDefaults(String groupId) throws IOException, ApiException {
        return this.getGroupGreetingsDefaults(this.createGetGroupGreetingsDefaultsRequest(groupId));
    }

    public ApiResponse<DefaultGreetingList> getGroupGreetingsDefaultsWithHttpInfo(String groupId) throws IOException {
        return this.getGroupGreetingsDefaults(this.createGetGroupGreetingsDefaultsRequest(groupId).withHttpInfo());
    }

    private GetGroupGreetingsDefaultsRequest createGetGroupGreetingsDefaultsRequest(String groupId) {
        return GetGroupGreetingsDefaultsRequest.builder().withGroupId(groupId).build();
    }

    public DefaultGreetingList getGroupGreetingsDefaults(GetGroupGreetingsDefaultsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DefaultGreetingList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DefaultGreetingList> getGroupGreetingsDefaults(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DefaultGreetingList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DomainEntityListing getUserGreetings(String userId, Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getUserGreetings(this.createGetUserGreetingsRequest(userId, pageSize, pageNumber));
    }

    public ApiResponse<DomainEntityListing> getUserGreetingsWithHttpInfo(String userId, Integer pageSize, Integer pageNumber) throws IOException {
        return this.getUserGreetings(this.createGetUserGreetingsRequest(userId, pageSize, pageNumber).withHttpInfo());
    }

    private GetUserGreetingsRequest createGetUserGreetingsRequest(String userId, Integer pageSize, Integer pageNumber) {
        return GetUserGreetingsRequest.builder().withUserId(userId).withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public DomainEntityListing getUserGreetings(GetUserGreetingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DomainEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DomainEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DomainEntityListing> getUserGreetings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DomainEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DefaultGreetingList getUserGreetingsDefaults(String userId) throws IOException, ApiException {
        return this.getUserGreetingsDefaults(this.createGetUserGreetingsDefaultsRequest(userId));
    }

    public ApiResponse<DefaultGreetingList> getUserGreetingsDefaultsWithHttpInfo(String userId) throws IOException {
        return this.getUserGreetingsDefaults(this.createGetUserGreetingsDefaultsRequest(userId).withHttpInfo());
    }

    private GetUserGreetingsDefaultsRequest createGetUserGreetingsDefaultsRequest(String userId) {
        return GetUserGreetingsDefaultsRequest.builder().withUserId(userId).build();
    }

    public DefaultGreetingList getUserGreetingsDefaults(GetUserGreetingsDefaultsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DefaultGreetingList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DefaultGreetingList> getUserGreetingsDefaults(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DefaultGreetingList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Greeting postGreetings(Greeting body) throws IOException, ApiException {
        return this.postGreetings(this.createPostGreetingsRequest(body));
    }

    public ApiResponse<Greeting> postGreetingsWithHttpInfo(Greeting body) throws IOException {
        return this.postGreetings(this.createPostGreetingsRequest(body).withHttpInfo());
    }

    private PostGreetingsRequest createPostGreetingsRequest(Greeting body) {
        return PostGreetingsRequest.builder().withBody(body).build();
    }

    public Greeting postGreetings(PostGreetingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Greeting> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Greeting>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Greeting> postGreetings(ApiRequest<Greeting> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Greeting>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Greeting postGroupGreetings(String groupId, Greeting body) throws IOException, ApiException {
        return this.postGroupGreetings(this.createPostGroupGreetingsRequest(groupId, body));
    }

    public ApiResponse<Greeting> postGroupGreetingsWithHttpInfo(String groupId, Greeting body) throws IOException {
        return this.postGroupGreetings(this.createPostGroupGreetingsRequest(groupId, body).withHttpInfo());
    }

    private PostGroupGreetingsRequest createPostGroupGreetingsRequest(String groupId, Greeting body) {
        return PostGroupGreetingsRequest.builder().withGroupId(groupId).withBody(body).build();
    }

    public Greeting postGroupGreetings(PostGroupGreetingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Greeting> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Greeting>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Greeting> postGroupGreetings(ApiRequest<Greeting> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Greeting>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Greeting postUserGreetings(String userId, Greeting body) throws IOException, ApiException {
        return this.postUserGreetings(this.createPostUserGreetingsRequest(userId, body));
    }

    public ApiResponse<Greeting> postUserGreetingsWithHttpInfo(String userId, Greeting body) throws IOException {
        return this.postUserGreetings(this.createPostUserGreetingsRequest(userId, body).withHttpInfo());
    }

    private PostUserGreetingsRequest createPostUserGreetingsRequest(String userId, Greeting body) {
        return PostUserGreetingsRequest.builder().withUserId(userId).withBody(body).build();
    }

    public Greeting postUserGreetings(PostUserGreetingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Greeting> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Greeting>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Greeting> postUserGreetings(ApiRequest<Greeting> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Greeting>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Greeting putGreeting(String greetingId, Greeting body) throws IOException, ApiException {
        return this.putGreeting(this.createPutGreetingRequest(greetingId, body));
    }

    public ApiResponse<Greeting> putGreetingWithHttpInfo(String greetingId, Greeting body) throws IOException {
        return this.putGreeting(this.createPutGreetingRequest(greetingId, body).withHttpInfo());
    }

    private PutGreetingRequest createPutGreetingRequest(String greetingId, Greeting body) {
        return PutGreetingRequest.builder().withGreetingId(greetingId).withBody(body).build();
    }

    public Greeting putGreeting(PutGreetingRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Greeting> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Greeting>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Greeting> putGreeting(ApiRequest<Greeting> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Greeting>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DefaultGreetingList putGreetingsDefaults(DefaultGreetingList body) throws IOException, ApiException {
        return this.putGreetingsDefaults(this.createPutGreetingsDefaultsRequest(body));
    }

    public ApiResponse<DefaultGreetingList> putGreetingsDefaultsWithHttpInfo(DefaultGreetingList body) throws IOException {
        return this.putGreetingsDefaults(this.createPutGreetingsDefaultsRequest(body).withHttpInfo());
    }

    private PutGreetingsDefaultsRequest createPutGreetingsDefaultsRequest(DefaultGreetingList body) {
        return PutGreetingsDefaultsRequest.builder().withBody(body).build();
    }

    public DefaultGreetingList putGreetingsDefaults(PutGreetingsDefaultsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DefaultGreetingList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DefaultGreetingList> putGreetingsDefaults(ApiRequest<DefaultGreetingList> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DefaultGreetingList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DefaultGreetingList putGroupGreetingsDefaults(String groupId, DefaultGreetingList body) throws IOException, ApiException {
        return this.putGroupGreetingsDefaults(this.createPutGroupGreetingsDefaultsRequest(groupId, body));
    }

    public ApiResponse<DefaultGreetingList> putGroupGreetingsDefaultsWithHttpInfo(String groupId, DefaultGreetingList body) throws IOException {
        return this.putGroupGreetingsDefaults(this.createPutGroupGreetingsDefaultsRequest(groupId, body).withHttpInfo());
    }

    private PutGroupGreetingsDefaultsRequest createPutGroupGreetingsDefaultsRequest(String groupId, DefaultGreetingList body) {
        return PutGroupGreetingsDefaultsRequest.builder().withGroupId(groupId).withBody(body).build();
    }

    public DefaultGreetingList putGroupGreetingsDefaults(PutGroupGreetingsDefaultsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DefaultGreetingList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DefaultGreetingList> putGroupGreetingsDefaults(ApiRequest<DefaultGreetingList> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DefaultGreetingList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DefaultGreetingList putUserGreetingsDefaults(String userId, DefaultGreetingList body) throws IOException, ApiException {
        return this.putUserGreetingsDefaults(this.createPutUserGreetingsDefaultsRequest(userId, body));
    }

    public ApiResponse<DefaultGreetingList> putUserGreetingsDefaultsWithHttpInfo(String userId, DefaultGreetingList body) throws IOException {
        return this.putUserGreetingsDefaults(this.createPutUserGreetingsDefaultsRequest(userId, body).withHttpInfo());
    }

    private PutUserGreetingsDefaultsRequest createPutUserGreetingsDefaultsRequest(String userId, DefaultGreetingList body) {
        return PutUserGreetingsDefaultsRequest.builder().withUserId(userId).withBody(body).build();
    }

    public DefaultGreetingList putUserGreetingsDefaults(PutUserGreetingsDefaultsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DefaultGreetingList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DefaultGreetingList> putUserGreetingsDefaults(ApiRequest<DefaultGreetingList> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DefaultGreetingList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

