/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.InboundRoute;
import java.util.HashMap;
import java.util.Map;

public class PostRoutingEmailDomainRoutesRequest {
    private String domainName;
    private InboundRoute body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public PostRoutingEmailDomainRoutesRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public InboundRoute getBody() {
        return this.body;
    }

    public void setBody(InboundRoute body) {
        this.body = body;
    }

    public PostRoutingEmailDomainRoutesRequest withBody(InboundRoute body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostRoutingEmailDomainRoutesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<InboundRoute> withHttpInfo() {
        if (this.domainName == null) {
            throw new IllegalStateException("Missing the required parameter 'domainName' when building request for PostRoutingEmailDomainRoutesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostRoutingEmailDomainRoutesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/routing/email/domains/{domainName}/routes").withPathParameter("domainName", this.domainName).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String domainName, InboundRoute body) {
        return new Builder().withRequiredParams(domainName, body);
    }

    public static class Builder {
        private final PostRoutingEmailDomainRoutesRequest request = new PostRoutingEmailDomainRoutesRequest();

        private Builder() {
        }

        public Builder withDomainName(String domainName) {
            this.request.setDomainName(domainName);
            return this;
        }

        public Builder withBody(InboundRoute body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String domainName, InboundRoute body) {
            this.request.setDomainName(domainName);
            this.request.setBody(body);
            return this;
        }

        public PostRoutingEmailDomainRoutesRequest build() {
            if (this.request.domainName == null) {
                throw new IllegalStateException("Missing the required parameter 'domainName' when building request for PostRoutingEmailDomainRoutesRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostRoutingEmailDomainRoutesRequest.");
            }
            return this.request;
        }
    }
}

